/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftClassMerger;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.SnowmanClassVisitor;
import net.fabricmc.loom.util.SyntheticParameterClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class MinecraftJarMerger
implements AutoCloseable {
    private static final MinecraftClassMerger CLASS_MERGER = new MinecraftClassMerger();
    private final FileSystemUtil.Delegate inputClientFs;
    private final FileSystemUtil.Delegate inputServerFs;
    private final FileSystemUtil.Delegate outputFs;
    private final Path inputClient;
    private final Path inputServer;
    private final Map<String, Entry> entriesClient;
    private final Map<String, Entry> entriesServer;
    private final Set<String> entriesAll;
    private boolean removeSnowmen = false;
    private boolean offsetSyntheticsParams = false;

    public MinecraftJarMerger(File inputClient, File inputServer, File output) throws IOException {
        if (output.exists() && !output.delete()) {
            throw new IOException("Could not delete " + output.getName());
        }
        this.inputClientFs = FileSystemUtil.getJarFileSystem(inputClient, false);
        this.inputClient = this.inputClientFs.get().getPath("/", new String[0]);
        this.inputServerFs = FileSystemUtil.getJarFileSystem(inputServer, false);
        this.inputServer = this.inputServerFs.get().getPath("/", new String[0]);
        this.outputFs = FileSystemUtil.getJarFileSystem(output, true);
        this.entriesClient = new HashMap<String, Entry>();
        this.entriesServer = new HashMap<String, Entry>();
        this.entriesAll = new TreeSet<String>();
    }

    public void enableSnowmanRemoval() {
        this.removeSnowmen = true;
    }

    public void enableSyntheticParamsOffset() {
        this.offsetSyntheticsParams = true;
    }

    @Override
    public void close() throws IOException {
        this.inputClientFs.close();
        this.inputServerFs.close();
        this.outputFs.close();
    }

    private void readToMap(final Map<String, Entry> map, Path input) {
        try {
            Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                    if (attr.isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!path.getFileName().toString().endsWith(".class")) {
                        if (path.toString().equals("/META-INF/MANIFEST.MF")) {
                            map.put("META-INF/MANIFEST.MF", new Entry(path, attr, "Manifest-Version: 1.0\nMain-Class: net.minecraft.client.Main\n".getBytes(StandardCharsets.UTF_8)));
                        } else {
                            if (path.toString().startsWith("/META-INF/") && (path.toString().endsWith(".SF") || path.toString().endsWith(".RSA"))) {
                                return FileVisitResult.CONTINUE;
                            }
                            map.put(path.toString().substring(1), new Entry(path, attr, null));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    byte[] output = Files.readAllBytes(path);
                    map.put(path.toString().substring(1), new Entry(path, attr, output));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void add(Entry entry) throws IOException {
        Path outPath = this.outputFs.get().getPath(entry.path.toString(), new String[0]);
        if (outPath.getParent() != null) {
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
        }
        if (entry.data != null) {
            Files.write(outPath, entry.data, StandardOpenOption.CREATE_NEW);
        } else {
            Files.copy(entry.path, outPath, new CopyOption[0]);
        }
        Files.getFileAttributeView(outPath, BasicFileAttributeView.class, new LinkOption[0]).setTimes(entry.metadata.creationTime(), entry.metadata.lastAccessTime(), entry.metadata.lastModifiedTime());
    }

    public void merge() throws IOException {
        ExecutorService service = Executors.newFixedThreadPool(2);
        service.submit(() -> this.readToMap(this.entriesClient, this.inputClient));
        service.submit(() -> this.readToMap(this.entriesServer, this.inputServer));
        service.shutdown();
        try {
            service.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.entriesAll.addAll(this.entriesClient.keySet());
        this.entriesAll.addAll(this.entriesServer.keySet());
        List<Entry> entries = this.entriesAll.parallelStream().map(entry -> {
            Entry result;
            boolean isClass = entry.endsWith(".class");
            boolean isMinecraft = this.entriesClient.containsKey(entry) || entry.startsWith("net/minecraft") || !entry.contains("/");
            String side = null;
            Entry entry1 = this.entriesClient.get(entry);
            Entry entry2 = this.entriesServer.get(entry);
            if (entry1 != null && entry2 != null) {
                result = Arrays.equals(entry1.data, entry2.data) ? entry1 : (isClass ? new Entry(entry1.path, entry1.metadata, CLASS_MERGER.merge(entry1.data, entry2.data)) : entry1);
            } else {
                result = entry1;
                if (result != null) {
                    side = "CLIENT";
                } else {
                    result = entry2;
                    if (result != null) {
                        side = "SERVER";
                    }
                }
            }
            if (isClass && !isMinecraft && "SERVER".equals(side)) {
                return null;
            }
            if (result != null) {
                if (isMinecraft && isClass) {
                    ClassWriter writer;
                    byte[] data = result.data;
                    ClassReader reader = new ClassReader(data);
                    Object visitor = writer = new ClassWriter(0);
                    if (side != null) {
                        visitor = new MinecraftClassMerger.SidedClassVisitor(589824, (ClassVisitor)visitor, side);
                    }
                    if (this.removeSnowmen) {
                        visitor = new SnowmanClassVisitor(589824, (ClassVisitor)visitor);
                    }
                    if (this.offsetSyntheticsParams) {
                        visitor = new SyntheticParameterClassVisitor(589824, (ClassVisitor)visitor);
                    }
                    if (visitor != writer) {
                        reader.accept((ClassVisitor)visitor, 0);
                        data = writer.toByteArray();
                        result = new Entry(result.path, result.metadata, data);
                    }
                }
                return result;
            }
            return null;
        }).filter(Objects::nonNull).toList();
        for (Entry e : entries) {
            this.add(e);
        }
    }

    public static class Entry {
        public final Path path;
        public final BasicFileAttributes metadata;
        public final byte[] data;

        public Entry(Path path, BasicFileAttributes metadata, byte[] data) {
            this.path = path;
            this.metadata = metadata;
            this.data = data;
        }
    }
}

