/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.extras.unpick.UnpickLayer;
import net.fabricmc.loom.configuration.providers.mappings.intermediary.IntermediaryMappingLayer;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingNsRenamer;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.MappingFormat;
import org.jetbrains.annotations.Nullable;

public record FileMappingsLayer(Path path, String mappingPath, String fallbackSourceNamespace, String fallbackTargetNamespace, boolean enigma, boolean unpick, String mergeNamespace) implements MappingLayer,
UnpickLayer
{
    private static final String UNPICK_METADATA_PATH = "extras/unpick.json";
    private static final String UNPICK_DEFINITIONS_PATH = "extras/definitions.unpick";

    @Override
    public void visit(MappingVisitor mappingVisitor) throws IOException {
        if (!ZipUtils.isZip(this.path)) {
            this.visit(this.path, mappingVisitor);
        } else {
            try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(this.path);){
                this.visit(fileSystem.get().getPath(this.mappingPath, new String[0]), mappingVisitor);
            }
        }
    }

    private void visit(Path path, MappingVisitor mappingVisitor) throws IOException {
        MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch(mappingVisitor, this.mergeNamespace.toString());
        Map<String, String> fallbackNamespaceReplacements = Map.of("source", this.fallbackSourceNamespace, "target", this.fallbackTargetNamespace);
        MappingNsRenamer renamer = new MappingNsRenamer((MappingVisitor)nsSwitch, fallbackNamespaceReplacements);
        MappingReader.read((Path)path, (MappingFormat)(this.enigma ? MappingFormat.ENIGMA : null), (MappingVisitor)renamer);
    }

    @Override
    public MappingsNamespace getSourceNamespace() {
        return MappingsNamespace.of(this.mergeNamespace);
    }

    @Override
    public List<Class<? extends MappingLayer>> dependsOn() {
        return List.of(IntermediaryMappingLayer.class);
    }

    @Override
    @Nullable
    public UnpickLayer.UnpickData getUnpickData() throws IOException {
        if (!this.unpick) {
            return null;
        }
        if (!ZipUtils.isZip(this.path)) {
            throw new UnsupportedOperationException("Unpick is only supported for zip file mapping layers.");
        }
        try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(this.path);){
            Path unpickMetadata = fileSystem.get().getPath(UNPICK_METADATA_PATH, new String[0]);
            Path unpickDefinitions = fileSystem.get().getPath(UNPICK_DEFINITIONS_PATH, new String[0]);
            if (!Files.exists(unpickMetadata, new LinkOption[0])) {
                UnpickLayer.UnpickData unpickData = null;
                return unpickData;
            }
            UnpickLayer.UnpickData unpickData = UnpickLayer.UnpickData.read(unpickMetadata, unpickDefinitions);
            return unpickData;
        }
    }
}

