/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.MappingLayer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpec;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsProcessor;
import net.fabricmc.loom.configuration.providers.mappings.extras.unpick.UnpickLayer;
import net.fabricmc.loom.configuration.providers.mappings.utils.AddConstructorMappingVisitor;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingDstNsReorder;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.Tiny2Writer;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskDependency;

public class LayeredMappingsDependency
implements SelfResolvingDependency,
FileCollectionDependency {
    private static final String GROUP = "loom";
    private static final String MODULE = "mappings";
    private final Project project;
    private final MappingContext mappingContext;
    private final LayeredMappingSpec layeredMappingSpec;
    private final String version;

    public LayeredMappingsDependency(Project project, MappingContext mappingContext, LayeredMappingSpec layeredMappingSpec, String version) {
        this.project = project;
        this.mappingContext = mappingContext;
        this.layeredMappingSpec = layeredMappingSpec;
        this.version = version;
    }

    public Set<File> resolve() {
        Path mappingsDir = this.mappingContext.minecraftProvider().dir("layered").toPath();
        Path mappingsFile = mappingsDir.resolve(String.format("%s.%s-%s.tiny", GROUP, MODULE, this.getVersion()));
        if (!Files.exists(mappingsFile, new LinkOption[0]) || this.mappingContext.refreshDeps()) {
            try {
                LayeredMappingsProcessor processor = new LayeredMappingsProcessor(this.layeredMappingSpec);
                List<MappingLayer> layers = processor.resolveLayers(this.mappingContext);
                Files.deleteIfExists(mappingsFile);
                this.writeMapping(processor, layers, mappingsFile);
                this.writeSignatureFixes(processor, layers, mappingsFile);
                this.writeUnpickData(processor, layers, mappingsFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to resolve layered mappings", e);
            }
        }
        return Collections.singleton(mappingsFile.toFile());
    }

    private void writeMapping(LayeredMappingsProcessor processor, List<MappingLayer> layers, Path mappingsFile) throws IOException {
        MemoryMappingTree mappings = processor.getMappings(layers);
        try (StringWriter writer = new StringWriter();){
            Tiny2Writer tiny2Writer = new Tiny2Writer((Writer)writer, false);
            MappingDstNsReorder nsReorder = new MappingDstNsReorder((MappingVisitor)tiny2Writer, Collections.singletonList(MappingsNamespace.NAMED.toString()));
            MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch((MappingVisitor)nsReorder, MappingsNamespace.INTERMEDIARY.toString(), true);
            AddConstructorMappingVisitor addConstructor = new AddConstructorMappingVisitor((MappingVisitor)nsSwitch);
            mappings.accept((MappingVisitor)addConstructor);
            Files.deleteIfExists(mappingsFile);
            ZipUtils.add(mappingsFile, "mappings/mappings.tiny", ((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void writeSignatureFixes(LayeredMappingsProcessor processor, List<MappingLayer> layers, Path mappingsFile) throws IOException {
        Map<String, String> signatureFixes = processor.getSignatureFixes(layers);
        if (signatureFixes == null) {
            return;
        }
        byte[] data = LoomGradlePlugin.OBJECT_MAPPER.writeValueAsString(signatureFixes).getBytes(StandardCharsets.UTF_8);
        ZipUtils.add(mappingsFile, "extras/record_signatures.json", data);
    }

    private void writeUnpickData(LayeredMappingsProcessor processor, List<MappingLayer> layers, Path mappingsFile) throws IOException {
        UnpickLayer.UnpickData unpickData = processor.getUnpickData(layers);
        if (unpickData == null) {
            return;
        }
        ZipUtils.add(mappingsFile, "extras/definitions.unpick", unpickData.definitions());
        ZipUtils.add(mappingsFile, "extras/unpick.json", unpickData.metadata().asJson());
    }

    public Set<File> resolve(boolean transitive) {
        return this.resolve();
    }

    public TaskDependency getBuildDependencies() {
        return task -> Collections.emptySet();
    }

    public String getGroup() {
        return GROUP;
    }

    public String getName() {
        return MODULE;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean contentEquals(Dependency dependency) {
        if (dependency instanceof LayeredMappingsDependency) {
            LayeredMappingsDependency layeredMappingsDependency = (LayeredMappingsDependency)dependency;
            return Objects.equals(layeredMappingsDependency.getVersion(), this.getVersion());
        }
        return false;
    }

    public Dependency copy() {
        return new LayeredMappingsDependency(this.project, this.mappingContext, this.layeredMappingSpec, this.version);
    }

    public String getReason() {
        return null;
    }

    public void because(String s) {
    }

    public FileCollection getFiles() {
        return this.project.files(new Object[]{this.resolve()});
    }
}

