/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Usage;

public record SpecContextImpl(List<FabricModJson> modDependencies, List<FabricModJson> localMods, List<FabricModJson> compileRuntimeMods) implements SpecContext
{
    public static SpecContextImpl create(Project project) {
        return new SpecContextImpl(SpecContextImpl.getDependentMods(project), FabricModJsonHelpers.getModsInProject(project), SpecContextImpl.getCompileRuntimeMods(project));
    }

    private static List<FabricModJson> getDependentMods(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<FabricModJson> mods = new ArrayList<FabricModJson>();
        for (RemapConfigurationSettings entry : extension.getRemapConfigurations()) {
            Set artifacts = ((Configuration)entry.getSourceConfiguration().get()).resolve();
            for (File artifact : artifacts) {
                FabricModJson fabricModJson = FabricModJsonFactory.createFromZipNullable(artifact.toPath());
                if (fabricModJson == null) continue;
                mods.add(fabricModJson);
            }
        }
        if (!GradleUtils.getBooleanProperty(project, "fabric.loom.disableProjectDependentMods")) {
            for (Project dependentProject : SpecContextImpl.getDependentProjects(project).toList()) {
                mods.addAll(FabricModJsonHelpers.getModsInProject(dependentProject));
            }
        }
        return SpecContextImpl.sorted(mods);
    }

    private static Stream<Project> getDependentProjects(Project project) {
        Stream<Project> runtimeProjects = SpecContextImpl.getLoomProjectDependencies(project.getConfigurations().getByName("runtimeClasspath"));
        Stream<Project> compileProjects = SpecContextImpl.getLoomProjectDependencies(project.getConfigurations().getByName("compileClasspath"));
        return Stream.concat(runtimeProjects, compileProjects).distinct();
    }

    private static List<FabricModJson> getCompileRuntimeMods(Project project) {
        ArrayList<FabricModJson> mods = new ArrayList<FabricModJson>(SpecContextImpl.getCompileRuntimeModsFromRemapConfigs(project).toList());
        for (Project dependentProject : SpecContextImpl.getCompileRuntimeProjectDependencies(project).toList()) {
            mods.addAll(FabricModJsonHelpers.getModsInProject(dependentProject));
        }
        return Collections.unmodifiableList(mods);
    }

    private static Stream<FabricModJson> getCompileRuntimeModsFromRemapConfigs(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        List<Path> runtimeEntries = extension.getRuntimeRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()).flatMap(SpecContextImpl.resolveArtifacts(project, true)).toList();
        return extension.getCompileRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()).flatMap(SpecContextImpl.resolveArtifacts(project, false)).filter(runtimeEntries::contains).map(FabricModJsonFactory::createFromZipOptional).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparing(FabricModJson::getId));
    }

    private static Function<RemapConfigurationSettings, Stream<Path>> resolveArtifacts(Project project, boolean runtime) {
        Usage usage = (Usage)project.getObjects().named(Usage.class, runtime ? "java-runtime" : "java-api");
        return settings -> {
            Configuration configuration = ((Configuration)settings.getSourceConfiguration().get()).copyRecursive();
            configuration.setCanBeConsumed(false);
            configuration.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
            return configuration.resolve().stream().map(File::toPath);
        };
    }

    private static Stream<Project> getCompileRuntimeProjectDependencies(Project project) {
        Stream<Project> runtimeProjects = SpecContextImpl.getLoomProjectDependencies(project.getConfigurations().getByName("runtimeClasspath"));
        List<Project> compileProjects = SpecContextImpl.getLoomProjectDependencies(project.getConfigurations().getByName("compileClasspath")).toList();
        return runtimeProjects.filter(compileProjects::contains);
    }

    private static Stream<Project> getLoomProjectDependencies(Configuration configuration) {
        return configuration.getAllDependencies().withType(ProjectDependency.class).stream().map(ProjectDependency::getDependencyProject).filter(GradleUtils::isLoomProject);
    }

    private static List<FabricModJson> sorted(List<FabricModJson> mods) {
        return mods.stream().sorted(Comparator.comparing(FabricModJson::getId)).toList();
    }

    @Override
    public List<FabricModJson> modDependenciesCompileRuntime() {
        return this.compileRuntimeMods;
    }
}

