/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModJavadocProcessor
implements MinecraftJarProcessor<Spec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModJavadocProcessor.class);
    private final String name;

    @Inject
    public ModJavadocProcessor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Spec buildSpec(SpecContext context) {
        ArrayList<ModJavadoc> javadocs = new ArrayList<ModJavadoc>();
        for (FabricModJson fabricModJson : context.allMods()) {
            ModJavadoc javadoc = ModJavadoc.create(fabricModJson);
            if (javadoc == null) continue;
            javadocs.add(javadoc);
        }
        if (javadocs.isEmpty()) {
            return null;
        }
        javadocs.sort(Comparator.comparing(ModJavadoc::modId));
        return new Spec(Collections.unmodifiableList(javadocs));
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) {
    }

    @Override
    @Nullable
    public MinecraftJarProcessor.MappingsProcessor<Spec> processMappings() {
        return (mappings, spec, context) -> {
            for (ModJavadoc javadoc : spec.javadocs()) {
                javadoc.apply(mappings);
            }
            return true;
        };
    }

    public record ModJavadoc(String modId, MemoryMappingTree mappingTree, String mappingsHash) {
        @Nullable
        public static ModJavadoc create(FabricModJson fabricModJson) {
            String mappingsHash;
            String modId = fabricModJson.getId();
            JsonElement customElement = fabricModJson.getCustom("loom:provided_javadoc");
            if (customElement == null) {
                return null;
            }
            String javaDocPath = customElement.getAsString();
            MemoryMappingTree mappings = new MemoryMappingTree();
            try {
                byte[] data = fabricModJson.getSource().read(javaDocPath);
                mappingsHash = Checksum.sha1Hex(data);
                try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(data));){
                    MappingReader.read((Reader)reader, (MappingVisitor)mappings);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read javadoc from mod: " + modId, e);
            }
            if (!mappings.getSrcNamespace().equals(MappingsNamespace.INTERMEDIARY.toString())) {
                throw new IllegalStateException("Javadoc provided by mod (%s) must be have an intermediary source namespace".formatted(modId));
            }
            if (!mappings.getDstNamespaces().isEmpty()) {
                throw new IllegalStateException("Javadoc provided by mod (%s) must not contain any dst names".formatted(modId));
            }
            return new ModJavadoc(modId, mappings, mappingsHash);
        }

        public void apply(MemoryMappingTree target) {
            if (!this.mappingTree.getSrcNamespace().equals(target.getSrcNamespace())) {
                throw new IllegalStateException("Cannot apply mappings to differing namespaces. source: %s target: %s".formatted(this.mappingTree.getSrcNamespace(), target.getSrcNamespace()));
            }
            for (MappingTree.ClassMapping sourceClass : this.mappingTree.getClasses()) {
                MemoryMappingTree.ClassEntry targetClass = target.getClass(sourceClass.getSrcName());
                if (targetClass == null) {
                    LOGGER.warn("Could not find provided javadoc target class {} from mod {}", (Object)sourceClass.getSrcName(), (Object)this.modId);
                    continue;
                }
                this.applyComment((MappingTree.ElementMapping)sourceClass, (MappingTree.ElementMapping)targetClass);
                for (MappingTree.FieldMapping sourceField : sourceClass.getFields()) {
                    MappingTree.FieldMapping targetField = targetClass.getField(sourceField.getSrcName(), sourceField.getSrcDesc());
                    if (targetField == null) {
                        LOGGER.warn("Could not find provided javadoc target field {}{} from mod {}", new Object[]{sourceField.getSrcName(), sourceField.getSrcDesc(), this.modId});
                        continue;
                    }
                    this.applyComment(sourceField, targetField);
                }
                for (MappingTree.MethodMapping sourceMethod : sourceClass.getMethods()) {
                    MappingTree.MethodMapping targetMethod = targetClass.getMethod(sourceMethod.getSrcName(), sourceMethod.getSrcDesc());
                    if (targetMethod == null) {
                        LOGGER.warn("Could not find provided javadoc target method {}{} from mod {}", new Object[]{sourceMethod.getSrcName(), sourceMethod.getSrcDesc(), this.modId});
                        continue;
                    }
                    this.applyComment(sourceMethod, targetMethod);
                }
            }
        }

        private <T extends MappingTree.ElementMapping> void applyComment(T source, T target) {
            String sourceComment = source.getComment();
            if (sourceComment == null) {
                LOGGER.warn("Mod {} provided javadoc has mapping for {}, without comment", (Object)this.modId, source);
                return;
            }
            Object targetComment = target.getComment();
            targetComment = targetComment == null ? "" : (String)targetComment + "\n";
            targetComment = (String)targetComment + sourceComment;
            target.setComment((String)targetComment);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.modId, this.mappingsHash);
        }

        @Override
        public String toString() {
            return "ModJavadoc{modId='%s', mappingsHash='%s'}".formatted(this.modId, this.mappingsHash);
        }
    }

    public record Spec(List<ModJavadoc> javadocs) implements MinecraftJarProcessor.Spec
    {
    }
}

