/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.tinyremapper.TinyRemapper;

public final class ContextImplHelper {
    private ContextImplHelper() {
    }

    public static LazyCloseable<TinyRemapper> createRemapper(ConfigContext configContext, MappingsNamespace from, MappingsNamespace to) {
        return new LazyCloseable<TinyRemapper>(() -> {
            try {
                TinyRemapper tinyRemapper = TinyRemapperHelper.getTinyRemapper(configContext.project(), configContext.serviceManager(), from.toString(), to.toString());
                tinyRemapper.readClassPath(TinyRemapperHelper.getMinecraftCompileLibraries(configContext.project()));
                for (Path minecraftJar : configContext.extension().getMinecraftJars(MappingsNamespace.INTERMEDIARY)) {
                    tinyRemapper.readClassPath(new Path[]{minecraftJar});
                }
                return tinyRemapper;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create tiny remapper", e);
            }
        }, TinyRemapper::finish);
    }
}

