/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency;

import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ModDependency {
    private final ArtifactRef artifact;
    protected final String group;
    protected final String name;
    protected final String version;
    @Nullable
    protected final String classifier;
    protected final String mappingsSuffix;
    protected final Project project;

    public ModDependency(ArtifactRef artifact, String mappingsSuffix, Project project) {
        this.artifact = artifact;
        this.group = artifact.group();
        this.name = artifact.name();
        this.version = artifact.version();
        this.classifier = artifact.classifier();
        this.mappingsSuffix = mappingsSuffix;
        this.project = project;
    }

    public abstract boolean isCacheInvalid(Project var1, @Nullable String var2);

    public abstract void copyToCache(Project var1, Path var2, @Nullable String var3) throws IOException;

    public abstract void applyToProject(Project var1);

    protected LocalMavenHelper createMaven(String name) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        Path root = extension.getFiles().getRemappedModCache().toPath();
        return new LocalMavenHelper(this.getRemappedGroup(), name, this.version, this.classifier, root);
    }

    public ArtifactRef getInputArtifact() {
        return this.artifact;
    }

    protected String getRemappedGroup() {
        return this.getMappingsPrefix() + "." + this.group;
    }

    private String getMappingsPrefix() {
        return this.mappingsSuffix.replace(".", "_").replace("-", "_").replace("+", "_");
    }

    public Path getInputFile() {
        return this.artifact.path();
    }

    public Path getWorkingFile(@Nullable String classifier) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        String fileName = classifier == null ? String.format("%s-%s-%s.jar", this.getRemappedGroup(), this.name, this.version) : String.format("%s-%s-%s-%s.jar", this.getRemappedGroup(), this.name, this.version, classifier);
        return extension.getFiles().getProjectBuildCache().toPath().resolve("remapped_working").resolve(fileName);
    }

    public String toString() {
        return "ModDependency{group='" + this.group + "', name='" + this.name + "', version='" + this.version + "', classifier='" + this.classifier + "'}";
    }
}

