/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.jetbrains.annotations.Nullable;

public record ArtifactMetadata(boolean isFabricMod, RemapRequirements remapRequirements, @Nullable InstallerData installerData) {
    private static final String INSTALLER_PATH = "fabric-installer.json";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_REMAP_KEY = "Fabric-Loom-Remap";

    public static ArtifactMetadata create(ArtifactRef artifact) throws IOException {
        boolean isFabricMod;
        RemapRequirements remapRequirements = RemapRequirements.DEFAULT;
        InstallerData installerData = null;
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(artifact.path());){
            isFabricMod = FabricModJsonFactory.containsMod(fs);
            Path manifestPath = fs.getPath(MANIFEST_PATH, new String[0]);
            if (Files.exists(manifestPath, new LinkOption[0])) {
                Manifest manifest = new Manifest(new ByteArrayInputStream(Files.readAllBytes(manifestPath)));
                Attributes mainAttributes = manifest.getMainAttributes();
                String value = mainAttributes.getValue(MANIFEST_REMAP_KEY);
                if (value != null) {
                    RemapRequirements remapRequirements2 = remapRequirements = Boolean.parseBoolean(value) ? RemapRequirements.OPT_IN : RemapRequirements.OPT_OUT;
                }
                if (mainAttributes.getValue("Fabric-Loom-Mixin-Remap-Type") != null) {
                    throw new IllegalStateException("This version of loom does not support the mixin remap type value. Please update to the latest version of loom.");
                }
            }
            Path installerPath = fs.getPath(INSTALLER_PATH, new String[0]);
            if (isFabricMod && Files.exists(installerPath, new LinkOption[0])) {
                JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(installerPath, StandardCharsets.UTF_8), JsonObject.class);
                installerData = new InstallerData(artifact.version(), jsonObject);
            }
        }
        return new ArtifactMetadata(isFabricMod, remapRequirements, installerData);
    }

    public boolean shouldRemap() {
        return this.remapRequirements().getShouldRemap().test(this);
    }

    public static enum RemapRequirements {
        DEFAULT(ArtifactMetadata::isFabricMod),
        OPT_IN(true),
        OPT_OUT(false);

        private final Predicate<ArtifactMetadata> shouldRemap;

        private RemapRequirements(Predicate<ArtifactMetadata> shouldRemap) {
            this.shouldRemap = shouldRemap;
        }

        private RemapRequirements(boolean shouldRemap) {
            this.shouldRemap = artifactMetadata -> shouldRemap;
        }

        private Predicate<ArtifactMetadata> getShouldRemap() {
            return this.shouldRemap;
        }
    }
}

