/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ifaceinject;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterfaceInjectionProcessor
implements MinecraftJarProcessor<Spec> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterfaceInjectionProcessor.class);
    private final String name;
    private final boolean fromDependencies;

    @Inject
    public InterfaceInjectionProcessor(String name, boolean fromDependencies) {
        this.name = name;
        this.fromDependencies = fromDependencies;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Spec buildSpec(SpecContext context) {
        ArrayList<InjectedInterface> injectedInterfaces = new ArrayList<InjectedInterface>();
        injectedInterfaces.addAll(InjectedInterface.fromMods(context.localMods()));
        if (this.fromDependencies) {
            injectedInterfaces.addAll(InjectedInterface.fromMods(context.modDependenciesCompileRuntime()));
        }
        if (injectedInterfaces.isEmpty()) {
            return null;
        }
        return new Spec(injectedInterfaces);
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) throws IOException {
        MemoryMappingTree mappings = context.getMappings();
        int intermediaryIndex = mappings.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString());
        int namedIndex = mappings.getNamespaceId(MappingsNamespace.NAMED.toString());
        List<InjectedInterface> remappedInjectedInterfaces = spec.injectedInterfaces().stream().map(injectedInterface -> this.remap((InjectedInterface)injectedInterface, s -> mappings.mapClassName(s, intermediaryIndex, namedIndex))).toList();
        try {
            ZipUtils.transform(jar, this.getTransformers(remappedInjectedInterfaces));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to apply interface injections to " + jar, e);
        }
    }

    private InjectedInterface remap(InjectedInterface in, Function<String, String> remapper) {
        return new InjectedInterface(in.modId(), remapper.apply(in.className()), remapper.apply(in.ifaceName()));
    }

    private List<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> getTransformers(List<InjectedInterface> injectedInterfaces) {
        return injectedInterfaces.stream().collect(Collectors.groupingBy(InjectedInterface::className)).entrySet().stream().map(entry -> {
            String zipEntry = ((String)entry.getKey()).replaceAll("\\.", "/") + ".class";
            return new Pair<CallSite, ZipUtils.UnsafeUnaryOperator<byte[]>>((CallSite)((Object)zipEntry), this.getTransformer((List)entry.getValue()));
        }).toList();
    }

    private ZipUtils.UnsafeUnaryOperator<byte[]> getTransformer(List<InjectedInterface> injectedInterfaces) {
        return input -> {
            ClassReader reader = new ClassReader(input);
            ClassWriter writer = new ClassWriter(0);
            InjectingClassVisitor classVisitor = new InjectingClassVisitor(589824, writer, injectedInterfaces);
            reader.accept((ClassVisitor)classVisitor, 0);
            return writer.toByteArray();
        };
    }

    @Override
    public MinecraftJarProcessor.MappingsProcessor<Spec> processMappings() {
        return (mappings, spec, context) -> {
            if (!MappingsNamespace.INTERMEDIARY.toString().equals(mappings.getSrcNamespace())) {
                throw new IllegalStateException("Mapping tree must have intermediary src mappings not " + mappings.getSrcNamespace());
            }
            Map<String, List<InjectedInterface>> map = spec.injectedInterfaces().stream().collect(Collectors.groupingBy(InjectedInterface::className));
            for (Map.Entry<String, List<InjectedInterface>> entry : map.entrySet()) {
                String className = entry.getKey();
                List<InjectedInterface> injectedInterfaces = entry.getValue();
                MemoryMappingTree.ClassEntry classMapping = mappings.getClass(className);
                if (classMapping == null) {
                    String modIds = injectedInterfaces.stream().map(InjectedInterface::modId).distinct().collect(Collectors.joining(","));
                    LOGGER.warn("Failed to find class ({}) to add injected interfaces from mod(s) ({})", (Object)className, (Object)modIds);
                    continue;
                }
                classMapping.setComment(InterfaceInjectionProcessor.appendComment(classMapping.getComment(), injectedInterfaces));
            }
            return true;
        };
    }

    private static String appendComment(String comment, List<InjectedInterface> injectedInterfaces) {
        if (injectedInterfaces.isEmpty()) {
            return comment;
        }
        StringBuilder commentBuilder = comment == null ? new StringBuilder() : new StringBuilder(comment);
        for (InjectedInterface injectedInterface : injectedInterfaces) {
            String iiComment = "<p>Interface {@link %s} injected by mod %s</p>".formatted(injectedInterface.ifaceName().replace('/', '.').replace('$', '.'), injectedInterface.modId());
            if (commentBuilder.indexOf(iiComment) != -1) continue;
            if (commentBuilder.isEmpty()) {
                commentBuilder.append(iiComment);
                continue;
            }
            commentBuilder.append('\n').append(iiComment);
        }
        return comment;
    }

    private record InjectedInterface(String modId, String className, String ifaceName) {
        public static List<InjectedInterface> fromMod(FabricModJson fabricModJson) {
            String modId = fabricModJson.getId();
            JsonElement jsonElement = fabricModJson.getCustom("loom:injected_interfaces");
            if (jsonElement == null) {
                return Collections.emptyList();
            }
            JsonObject addedIfaces = jsonElement.getAsJsonObject();
            ArrayList<InjectedInterface> result = new ArrayList<InjectedInterface>();
            for (String className : addedIfaces.keySet()) {
                JsonArray ifaceNames = addedIfaces.getAsJsonArray(className);
                for (JsonElement ifaceName : ifaceNames) {
                    result.add(new InjectedInterface(modId, className, ifaceName.getAsString()));
                }
            }
            return result;
        }

        public static List<InjectedInterface> fromMods(List<FabricModJson> fabricModJsons) {
            return fabricModJsons.stream().map(InjectedInterface::fromMod).flatMap(Collection::stream).toList();
        }
    }

    public record Spec(List<InjectedInterface> injectedInterfaces) implements MinecraftJarProcessor.Spec
    {
    }

    private static class InjectingClassVisitor
    extends ClassVisitor {
        private static final int INTERFACE_ACCESS = 1545;
        private final List<InjectedInterface> injectedInterfaces;
        private final Set<String> knownInnerClasses = new HashSet<String>();

        InjectingClassVisitor(int asmVersion, ClassWriter writer, List<InjectedInterface> injectedInterfaces) {
            super(asmVersion, (ClassVisitor)writer);
            this.injectedInterfaces = injectedInterfaces;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            LinkedHashSet<String> modifiedInterfaces = new LinkedHashSet<String>(interfaces.length + this.injectedInterfaces.size());
            Collections.addAll(modifiedInterfaces, interfaces);
            for (InjectedInterface injectedInterface : this.injectedInterfaces) {
                modifiedInterfaces.add(injectedInterface.ifaceName());
            }
            if (signature != null) {
                StringBuilder resultingSignature = new StringBuilder(signature);
                for (InjectedInterface injectedInterface : this.injectedInterfaces) {
                    String superinterfaceSignature = "L" + injectedInterface.ifaceName() + ";";
                    if (resultingSignature.indexOf(superinterfaceSignature) != -1) continue;
                    resultingSignature.append(superinterfaceSignature);
                }
                signature = resultingSignature.toString();
            }
            super.visit(version, access, name, signature, superName, modifiedInterfaces.toArray(new String[0]));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.knownInnerClasses.add(name);
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public void visitEnd() {
            for (InjectedInterface itf : this.injectedInterfaces) {
                String innerName;
                String outerName;
                if (this.knownInnerClasses.contains(itf.ifaceName())) continue;
                int simpleNameIdx = itf.ifaceName().lastIndexOf(47);
                String simpleName = simpleNameIdx == -1 ? itf.ifaceName() : itf.ifaceName().substring(simpleNameIdx + 1);
                int lastIdx = -1;
                int dollarIdx = -1;
                while ((dollarIdx = simpleName.indexOf(36, dollarIdx + 1)) != -1) {
                    if (dollarIdx - lastIdx == 1) continue;
                    if (lastIdx != -1) {
                        outerName = itf.ifaceName().substring(0, simpleNameIdx + 1 + lastIdx);
                        innerName = simpleName.substring(lastIdx + 1, dollarIdx);
                        super.visitInnerClass(outerName + "$" + innerName, outerName, innerName, 1545);
                    }
                    lastIdx = dollarIdx;
                }
                if (lastIdx == -1 || lastIdx == simpleName.length()) continue;
                outerName = itf.ifaceName().substring(0, simpleNameIdx + 1 + lastIdx);
                innerName = simpleName.substring(lastIdx + 1);
                super.visitInnerClass(outerName + "$" + innerName, outerName, innerName, 1545);
            }
            super.visitEnd();
        }
    }
}

