/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.ide.idea.IdeaSyncTask;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.task.LoomTasks;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaConfiguration
implements Runnable {
    private static final String INIT_SCRIPT_NAME = "ijmiscinit";
    private static final Pattern NOTATION_PATTERN = Pattern.compile("'net\\.minecraft:(?<name>.*):(.*):sources'");

    @Inject
    protected abstract Project getProject();

    @Override
    public void run() {
        TaskProvider ideaSyncTask = this.getProject().getTasks().register("ideaSyncTask", IdeaSyncTask.class, task -> {
            if (LoomGradleExtension.get(this.getProject()).getRunConfigs().stream().anyMatch(RunConfigSettings::isIdeConfigGenerated)) {
                task.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            } else {
                task.setEnabled(false);
            }
        });
        this.getProject().getTasks().configureEach(task -> {
            if (task.getName().equals("DownloadSources")) {
                IdeaConfiguration.hookDownloadSources(this.getProject(), task);
            }
        });
        if (!IdeaUtils.isIdeaSync()) {
            return;
        }
        StartParameter startParameter = this.getProject().getGradle().getStartParameter();
        ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
        taskRequests.add(new DefaultTaskExecutionRequest(List.of("ideaSyncTask")));
        startParameter.setTaskRequests(taskRequests);
    }

    private static void hookDownloadSources(Project project, Task task) {
        List initScripts = project.getGradle().getStartParameter().getInitScripts();
        for (File initScript : initScripts) {
            if (!initScript.getName().contains(INIT_SCRIPT_NAME)) continue;
            try {
                String script = Files.readString(initScript.toPath(), StandardCharsets.UTF_8);
                String notation = IdeaConfiguration.parseInitScript(project, script);
                if (notation == null) continue;
                task.dependsOn(new Object[]{IdeaConfiguration.getGenSourcesTaskName(LoomGradleExtension.get(project), notation)});
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    private static String parseInitScript(Project project, String script) {
        if (!(script.contains("Attempt to download sources from") && script.contains("downloadSources_") && script.contains("'%s'".formatted(project.getPath())))) {
            return null;
        }
        Matcher matcher = NOTATION_PATTERN.matcher(script);
        if (matcher.find()) {
            return matcher.group("name");
        }
        return null;
    }

    private static String getGenSourcesTaskName(LoomGradleExtension extension, String notation) {
        MinecraftJarConfiguration configuration = (MinecraftJarConfiguration)((Object)extension.getMinecraftJarConfiguration().get());
        if (configuration == MinecraftJarConfiguration.SPLIT) {
            if (notation.toLowerCase(Locale.ROOT).contains("minecraft-clientonly")) {
                return "genClientOnlySources";
            }
            return "genCommonSources";
        }
        return "genSources";
    }
}

