/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.io.File;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.GenerateSourcesTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;

public abstract class DecompileConfiguration<T extends MappedMinecraftProvider> {
    protected final Project project;
    protected final T minecraftProvider;
    protected final LoomGradleExtension extension;
    protected final MappingConfiguration mappingConfiguration;

    public DecompileConfiguration(ConfigContext configContext, T minecraftProvider) {
        this.project = configContext.project();
        this.minecraftProvider = minecraftProvider;
        this.extension = configContext.extension();
        this.mappingConfiguration = this.extension.getMappingConfiguration();
    }

    public abstract void afterEvaluation();

    protected final void configureUnpick(GenerateSourcesTask task, File unpickOutputJar) {
        ConfigurationContainer configurations = task.getProject().getConfigurations();
        task.getUnpickDefinitions().set(this.mappingConfiguration.getUnpickDefinitionsFile());
        task.getUnpickOutputJar().set(unpickOutputJar);
        task.getUnpickConstantJar().setFrom((Iterable)configurations.getByName("mappingsConstants"));
        task.getUnpickClasspath().setFrom((Iterable)configurations.getByName("minecraftLibraries"));
        task.getUnpickClasspath().from(new Object[]{configurations.getByName("modCompileClasspathMapped")});
    }
}

