/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.io.File;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.util.download.DownloadException;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.tasks.Jar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class FabricApiExtension {
    private static final String DATAGEN_SOURCESET_NAME = "datagen";
    private static final HashMap<String, Map<String, String>> moduleVersionCache = new HashMap();
    private static final HashMap<String, Map<String, String>> deprecatedModuleVersionCache = new HashMap();

    @Inject
    public abstract Project getProject();

    public Dependency module(String moduleName, String fabricApiVersion) {
        return this.getProject().getDependencies().create((Object)this.getDependencyNotation(moduleName, fabricApiVersion));
    }

    public String moduleVersion(String moduleName, String fabricApiVersion) {
        String moduleVersion = (String)moduleVersionCache.computeIfAbsent(fabricApiVersion, this::getApiModuleVersions).get(moduleName);
        if (moduleVersion == null) {
            moduleVersion = (String)deprecatedModuleVersionCache.computeIfAbsent(fabricApiVersion, this::getDeprecatedApiModuleVersions).get(moduleName);
        }
        if (moduleVersion == null) {
            throw new RuntimeException("Failed to find module version for module: " + moduleName);
        }
        return moduleVersion;
    }

    public void configureDataGeneration() {
        this.configureDataGeneration((Action<DataGenerationSettings>)((Action)dataGenerationSettings -> {}));
    }

    public void configureDataGeneration(Action<DataGenerationSettings> action) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        TaskContainer taskContainer = this.getProject().getTasks();
        DataGenerationSettings settings = (DataGenerationSettings)this.getProject().getObjects().newInstance(DataGenerationSettings.class, new Object[0]);
        settings.getOutputDirectory().set(this.getProject().file((Object)"src/main/generated"));
        settings.getCreateRunConfiguration().convention((Object)true);
        settings.getCreateSourceSet().convention((Object)true);
        settings.getCreateSourceSet().convention((Object)false);
        settings.getStrictValidation().convention((Object)false);
        settings.getAddToResources().convention((Object)true);
        action.execute((Object)settings);
        SourceSet mainSourceSet = SourceSetHelper.getMainSourceSet(this.getProject());
        File outputDirectory = (File)settings.getOutputDirectory().getAsFile().get();
        if (((Boolean)settings.getAddToResources().get()).booleanValue()) {
            mainSourceSet.resources(files -> {
                HashSet<File> srcDirs = new HashSet<File>(files.getSrcDirs());
                srcDirs.add(outputDirectory);
                files.setSrcDirs(srcDirs);
            });
        }
        taskContainer.getByName("jar", task -> {
            Jar jar = (Jar)task;
            jar.exclude(new String[]{".cache/**"});
        });
        taskContainer.getByName("clean", task -> {
            Delete clean = (Delete)task;
            clean.delete(new Object[]{outputDirectory});
        });
        if (((Boolean)settings.getCreateSourceSet().get()).booleanValue()) {
            if (!settings.getModId().isPresent()) {
                throw new IllegalStateException("DataGenerationSettings.getModId() must be set when using split sources.");
            }
            SourceSetContainer sourceSets = SourceSetHelper.getSourceSets(this.getProject());
            sourceSets.create(DATAGEN_SOURCESET_NAME, sourceSet -> {
                sourceSet.setCompileClasspath(sourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()));
                sourceSet.setRuntimeClasspath(sourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()));
                FabricApiExtension.extendsFrom(this.getProject(), sourceSet.getCompileClasspathConfigurationName(), mainSourceSet.getCompileClasspathConfigurationName());
                FabricApiExtension.extendsFrom(this.getProject(), sourceSet.getRuntimeClasspathConfigurationName(), mainSourceSet.getRuntimeClasspathConfigurationName());
            });
            extension.getMods().create((String)settings.getModId().get(), mod -> mod.sourceSet(DATAGEN_SOURCESET_NAME));
        }
        if (((Boolean)settings.getCreateRunConfiguration().get()).booleanValue()) {
            extension.getRunConfigs().create(DATAGEN_SOURCESET_NAME, run -> {
                run.name("Data Generation");
                run.inherit((RunConfigSettings)extension.getRunConfigs().getByName("server"));
                run.property("fabric-api.datagen");
                run.property("fabric-api.datagen.output-dir", outputDirectory.getAbsolutePath());
                run.runDir("build/datagen");
                if (settings.getModId().isPresent()) {
                    run.property("fabric-api.datagen.modid", (String)settings.getModId().get());
                }
                if (((Boolean)settings.getStrictValidation().get()).booleanValue()) {
                    run.property("fabric-api.datagen.strict-validation", "true");
                }
                if (((Boolean)settings.getCreateSourceSet().get()).booleanValue()) {
                    run.source(DATAGEN_SOURCESET_NAME);
                }
            });
        }
    }

    private String getDependencyNotation(String moduleName, String fabricApiVersion) {
        return String.format("net.fabricmc.fabric-api:%s:%s", moduleName, this.moduleVersion(moduleName, fabricApiVersion));
    }

    private Map<String, String> getApiModuleVersions(String fabricApiVersion) {
        try {
            return this.populateModuleVersionMap(this.getApiMavenPom(fabricApiVersion));
        }
        catch (PomNotFoundException e) {
            throw new RuntimeException("Could not find fabric-api version: " + fabricApiVersion);
        }
    }

    private Map<String, String> getDeprecatedApiModuleVersions(String fabricApiVersion) {
        try {
            return this.populateModuleVersionMap(this.getDeprecatedApiMavenPom(fabricApiVersion));
        }
        catch (PomNotFoundException e) {
            return Collections.emptyMap();
        }
    }

    private Map<String, String> populateModuleVersionMap(File pomFile) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document pom = docBuilder.parse(pomFile);
            HashMap<String, String> versionMap = new HashMap<String, String>();
            NodeList dependencies = ((Element)pom.getElementsByTagName("dependencies").item(0)).getElementsByTagName("dependency");
            for (int i = 0; i < dependencies.getLength(); ++i) {
                Element dep = (Element)dependencies.item(i);
                Element artifact = (Element)dep.getElementsByTagName("artifactId").item(0);
                Element version = (Element)dep.getElementsByTagName("version").item(0);
                if (artifact == null || version == null) {
                    throw new RuntimeException("Failed to find artifact or version");
                }
                versionMap.put(artifact.getTextContent(), version.getTextContent());
            }
            return versionMap;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + pomFile.getName(), e);
        }
    }

    private File getApiMavenPom(String fabricApiVersion) throws PomNotFoundException {
        return this.getPom("fabric-api", fabricApiVersion);
    }

    private File getDeprecatedApiMavenPom(String fabricApiVersion) throws PomNotFoundException {
        return this.getPom("fabric-api-deprecated", fabricApiVersion);
    }

    private File getPom(String name, String version) throws PomNotFoundException {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        File mavenPom = new File(extension.getFiles().getUserCache(), "fabric-api/%s-%s.pom".formatted(name, version));
        try {
            extension.download(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-api/%2$s/%1$s/%2$s-%1$s.pom", version, name)).defaultCache().downloadPath(mavenPom.toPath());
        }
        catch (DownloadException e) {
            if (e.getStatusCode() == 404) {
                throw new PomNotFoundException(e);
            }
            throw new UncheckedIOException("Failed to download maven info to " + mavenPom.getName(), e);
        }
        return mavenPom;
    }

    private static void extendsFrom(Project project, String name, String extendsFrom) {
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.named(name, configuration -> configuration.extendsFrom(new Configuration[]{configurations.getByName(extendsFrom)}));
    }

    public static interface DataGenerationSettings {
        public RegularFileProperty getOutputDirectory();

        public Property<Boolean> getCreateRunConfiguration();

        public Property<Boolean> getCreateSourceSet();

        public Property<String> getModId();

        public Property<Boolean> getStrictValidation();

        public Property<Boolean> getAddToResources();
    }

    private static class PomNotFoundException
    extends Exception {
        PomNotFoundException(Throwable cause) {
            super(cause);
        }
    }
}

