/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api;

import java.io.File;
import java.util.List;
import net.fabricmc.loom.api.InterfaceInjectionExtensionAPI;
import net.fabricmc.loom.api.MixinExtensionAPI;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.api.mappings.layered.spec.LayeredMappingSpecBuilder;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.configuration.providers.mappings.NoOpIntermediateMappingsProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.DeprecationHelper;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.ApiStatus;

public interface LoomGradleExtensionAPI {
    @ApiStatus.Internal
    public DeprecationHelper getDeprecationHelper();

    public RegularFileProperty getAccessWidenerPath();

    public NamedDomainObjectContainer<DecompilerOptions> getDecompilerOptions();

    public void decompilers(Action<NamedDomainObjectContainer<DecompilerOptions>> var1);

    @Deprecated
    public ListProperty<JarProcessor> getGameJarProcessors();

    @Deprecated
    default public void addJarProcessor(JarProcessor processor) {
        this.getGameJarProcessors().add((Object)processor);
    }

    public ListProperty<MinecraftJarProcessor<?>> getMinecraftJarProcessors();

    public void addMinecraftJarProcessor(Class<? extends MinecraftJarProcessor<?>> var1, Object ... var2);

    public ConfigurableFileCollection getLog4jConfigs();

    public Dependency officialMojangMappings();

    public Dependency layered(Action<LayeredMappingSpecBuilder> var1);

    public void runs(Action<NamedDomainObjectContainer<RunConfigSettings>> var1);

    public NamedDomainObjectContainer<RunConfigSettings> getRunConfigs();

    default public NamedDomainObjectContainer<RunConfigSettings> getRuns() {
        return this.getRunConfigs();
    }

    public void mixin(Action<MixinExtensionAPI> var1);

    public void mods(Action<NamedDomainObjectContainer<ModSettings>> var1);

    public NamedDomainObjectContainer<ModSettings> getMods();

    public NamedDomainObjectList<RemapConfigurationSettings> getRemapConfigurations();

    public RemapConfigurationSettings addRemapConfiguration(String var1, Action<RemapConfigurationSettings> var2);

    public void createRemapConfigurations(SourceSet var1);

    default public List<RemapConfigurationSettings> getCompileRemapConfigurations() {
        return this.getRemapConfigurations().stream().filter(element -> (Boolean)element.getOnCompileClasspath().get()).toList();
    }

    default public List<RemapConfigurationSettings> getRuntimeRemapConfigurations() {
        return this.getRemapConfigurations().stream().filter(element -> (Boolean)element.getOnRuntimeClasspath().get()).toList();
    }

    @ApiStatus.Experimental
    public MixinExtensionAPI getMixin();

    default public void interfaceInjection(Action<InterfaceInjectionExtensionAPI> action) {
        action.execute((Object)this.getInterfaceInjection());
    }

    public InterfaceInjectionExtensionAPI getInterfaceInjection();

    public Property<String> getCustomMinecraftManifest();

    public SetProperty<String> getKnownIndyBsms();

    @ApiStatus.Experimental
    public void disableDeprecatedPomGeneration(MavenPublication var1);

    public String getModVersion();

    public Property<Boolean> getEnableTransitiveAccessWideners();

    public Property<Boolean> getEnableModProvidedJavadoc();

    @ApiStatus.Experimental
    public IntermediateMappingsProvider getIntermediateMappingsProvider();

    @ApiStatus.Experimental
    public void setIntermediateMappingsProvider(IntermediateMappingsProvider var1);

    @ApiStatus.Experimental
    public <T extends IntermediateMappingsProvider> void setIntermediateMappingsProvider(Class<T> var1, Action<T> var2);

    @ApiStatus.Experimental
    default public void noIntermediateMappings() {
        this.setIntermediateMappingsProvider(NoOpIntermediateMappingsProvider.class, p -> {});
    }

    public File getMappingsFile();

    public GenerateSourcesTask getDecompileTask(DecompilerOptions var1, boolean var2);

    public Property<String> getIntermediaryUrl();

    public Property<MinecraftJarConfiguration> getMinecraftJarConfiguration();

    default public void serverOnlyMinecraftJar() {
        this.getMinecraftJarConfiguration().set((Object)MinecraftJarConfiguration.SERVER_ONLY);
    }

    default public void clientOnlyMinecraftJar() {
        this.getMinecraftJarConfiguration().set((Object)MinecraftJarConfiguration.CLIENT_ONLY);
    }

    default public void splitMinecraftJar() {
        this.getMinecraftJarConfiguration().set((Object)MinecraftJarConfiguration.SPLIT);
    }

    public void splitEnvironmentSourceSets();

    public boolean areEnvironmentSourceSetsSplit();

    public Property<Boolean> getRuntimeOnlyLog4j();

    public Property<Boolean> getSplitModDependencies();
}

