/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;

public final class GradleUtils {
    private GradleUtils() {
    }

    public static void afterSuccessfulEvaluation(Project project, Runnable afterEvaluate) {
        project.afterEvaluate(p -> {
            if (p.getState().getFailure() != null) {
                return;
            }
            afterEvaluate.run();
        });
    }

    public static void allLoomProjects(Gradle gradle, Consumer<Project> consumer) {
        gradle.allprojects(project -> {
            if (GradleUtils.isLoomProject(project)) {
                consumer.accept((Project)project);
            }
        });
    }

    public static boolean isLoomProject(Project project) {
        return project.getPluginManager().hasPlugin("fabric-loom");
    }

    public static Provider<Boolean> getBooleanPropertyProvider(Project project, String key) {
        return project.getProviders().gradleProperty(key).map(string -> {
            try {
                return Boolean.parseBoolean(string);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        });
    }

    public static boolean getBooleanProperty(Project project, String key) {
        return (Boolean)GradleUtils.getBooleanPropertyProvider(project, key).getOrElse((Object)false);
    }
}

