/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import java.util.function.Predicate;

final class FabricModJsonUtils {
    private FabricModJsonUtils() {
    }

    public static String readString(JsonObject jsonObject, String key) {
        JsonElement element = FabricModJsonUtils.getElement(jsonObject, key);
        FabricModJsonUtils.ensurePrimitive(element, JsonPrimitive::isString, key);
        return element.getAsString();
    }

    public static int readInt(JsonObject jsonObject, String key) {
        JsonElement element = FabricModJsonUtils.getElement(jsonObject, key);
        FabricModJsonUtils.ensurePrimitive(element, JsonPrimitive::isNumber, key);
        return element.getAsInt();
    }

    private static JsonElement getElement(JsonObject jsonObject, String key) {
        JsonElement element = jsonObject.get(key);
        if (element == null) {
            throw new ParseException("Unable to find json element for key (%s)", key);
        }
        return element;
    }

    private static void ensurePrimitive(JsonElement jsonElement, Predicate<JsonPrimitive> predicate, String key) {
        if (!jsonElement.isJsonPrimitive() || !predicate.test(jsonElement.getAsJsonPrimitive())) {
            throw new ParseException("Unexpected primitive type for key (%s)", key);
        }
    }

    static class ParseException
    extends RuntimeException {
        ParseException(String message, Object ... args) {
            super(String.format(Locale.ROOT, message, args));
        }
    }
}

