/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.StandardProtocolFamily;
import java.nio.channels.ServerSocketChannel;
import net.fabricmc.loom.util.Platform;

final class CurrentPlatform
implements Platform {
    static final Platform INSTANCE = new CurrentPlatform();
    private final Platform.OperatingSystem operatingSystem = CurrentPlatform.getCurrentOperatingSystem();
    private final Platform.Architecture architecture = CurrentPlatform.getCurrentArchitecture();
    private final boolean supportsUnixDomainSockets = CurrentPlatform.isUnixDomainSocketsSupported();

    private CurrentPlatform() {
    }

    private static Platform.OperatingSystem getCurrentOperatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return Platform.OperatingSystem.WINDOWS;
        }
        if (osName.contains("mac")) {
            return Platform.OperatingSystem.MAC_OS;
        }
        return Platform.OperatingSystem.LINUX;
    }

    private static Platform.Architecture getCurrentArchitecture() {
        String arch = System.getProperty("os.arch");
        final boolean is64Bit = arch.contains("64") || arch.startsWith("armv8");
        final boolean isArm = arch.startsWith("arm") || arch.startsWith("aarch64");
        return new Platform.Architecture(){

            @Override
            public boolean is64Bit() {
                return is64Bit;
            }

            @Override
            public boolean isArm() {
                return isArm;
            }
        };
    }

    private static boolean isUnixDomainSocketsSupported() {
        boolean bl;
        block9: {
            ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            try {
                bl = true;
                if (serverChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (serverChannel != null) {
                        try {
                            serverChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            serverChannel.close();
        }
        return bl;
    }

    @Override
    public Platform.OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Platform.Architecture getArchitecture() {
        return this.architecture;
    }

    @Override
    public boolean supportsUnixDomainSockets() {
        return this.supportsUnixDomainSockets;
    }
}

