/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.apache.commons.io.FileUtils;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateDLIConfigTask
extends AbstractLoomTask {
    @TaskAction
    public void run() throws IOException {
        boolean ansiSupportedIDE;
        MinecraftVersionMeta versionInfo = this.getExtension().getMinecraftProvider().getVersionInfo();
        File assetsDirectory = new File(this.getExtension().getFiles().getUserCache(), "assets");
        if (versionInfo.assets().equals("legacy")) {
            assetsDirectory = new File(assetsDirectory, "/legacy/" + versionInfo.id());
        }
        LaunchConfig launchConfig = new LaunchConfig().property("fabric.development", "true").property("fabric.remapClasspathFile", this.getExtension().getFiles().getRemapClasspathFile().getAbsolutePath()).property("log4j.configurationFile", this.getAllLog4JConfigFiles()).property("log4j2.formatMsgNoLookups", "true").argument("client", "--assetIndex").argument("client", this.getExtension().getMinecraftProvider().getVersionInfo().assetIndex().fabricId(this.getExtension().getMinecraftProvider().minecraftVersion())).argument("client", "--assetsDir").argument("client", assetsDirectory.getAbsolutePath());
        if (versionInfo.hasNativesToExtract()) {
            String nativesPath = this.getExtension().getFiles().getNativesDirectory(this.getProject()).getAbsolutePath();
            launchConfig.property("client", "java.library.path", nativesPath).property("client", "org.lwjgl.librarypath", nativesPath);
        }
        if (this.getExtension().areEnvironmentSourceSetsSplit()) {
            launchConfig.property("client", "fabric.gameJarPath.client", this.getGameJarPath("client"));
            launchConfig.property("fabric.gameJarPath", this.getGameJarPath("common"));
        }
        if (!this.getExtension().getMods().isEmpty()) {
            launchConfig.property("fabric.classPathGroups", this.getClassPathGroups());
        }
        boolean plainConsole = this.getProject().getGradle().getStartParameter().getConsoleOutput() == ConsoleOutput.Plain;
        boolean bl = ansiSupportedIDE = new File(this.getProject().getRootDir(), ".vscode").exists() || new File(this.getProject().getRootDir(), ".idea").exists() || Arrays.stream(this.getProject().getRootDir().listFiles()).anyMatch(file -> file.getName().endsWith(".iws"));
        if (ansiSupportedIDE && !plainConsole) {
            launchConfig.property("fabric.log.disableAnsi", "false");
        }
        FileUtils.writeStringToFile((File)this.getExtension().getFiles().getDevLauncherConfig(), (String)launchConfig.asString(), (Charset)StandardCharsets.UTF_8);
    }

    private String getAllLog4JConfigFiles() {
        return this.getExtension().getLog4jConfigs().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(","));
    }

    private String getGameJarPath(String env) {
        MappedMinecraftProvider.Split split = (MappedMinecraftProvider.Split)((Object)this.getExtension().getNamedMinecraftProvider());
        return switch (env) {
            case "client" -> split.getClientOnlyJar().getPath().toAbsolutePath().toString();
            case "common" -> split.getCommonJar().getPath().toAbsolutePath().toString();
            default -> throw new UnsupportedOperationException();
        };
    }

    private String getClassPathGroups() {
        return this.getExtension().getMods().stream().map(modSettings -> SourceSetHelper.getClasspath(modSettings, this.getProject()).stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator))).collect(Collectors.joining(File.pathSeparator + File.pathSeparator));
    }

    public static class LaunchConfig {
        private final Map<String, List<String>> values = new HashMap<String, List<String>>();

        public LaunchConfig property(String key, String value) {
            return this.property("common", key, value);
        }

        public LaunchConfig property(String side, String key, String value) {
            this.values.computeIfAbsent(side + "Properties", s -> new ArrayList()).add(String.format("%s=%s", key, value));
            return this;
        }

        public LaunchConfig argument(String value) {
            return this.argument("common", value);
        }

        public LaunchConfig argument(String side, String value) {
            this.values.computeIfAbsent(side + "Args", s -> new ArrayList()).add(value);
            return this;
        }

        public String asString() {
            StringJoiner stringJoiner = new StringJoiner("\n");
            for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
                stringJoiner.add(entry.getKey());
                for (String s : entry.getValue()) {
                    stringJoiner.add("\t" + s);
                }
            }
            return stringJoiner.toString();
        }
    }
}

