/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.extension.LoomFiles;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputFile;

public abstract class UnpickJarTask
extends JavaExec {
    @InputFile
    public abstract RegularFileProperty getInputJar();

    @InputFile
    public abstract RegularFileProperty getUnpickDefinitions();

    @InputFiles
    public abstract ConfigurableFileCollection getConstantJar();

    @InputFiles
    public abstract ConfigurableFileCollection getUnpickClasspath();

    @OutputFile
    public abstract RegularFileProperty getOutputJar();

    @Inject
    public UnpickJarTask() {
        this.classpath(new Object[]{this.getProject().getConfigurations().getByName("unpick")});
        this.getMainClass().set((Object)"daomephsta.unpick.cli.Main");
        this.getConstantJar().setFrom((Iterable)this.getProject().getConfigurations().getByName("mappingsConstants"));
        this.getUnpickClasspath().setFrom((Iterable)this.getProject().getConfigurations().getByName("minecraftLibraries"));
        this.getUnpickClasspath().from(new Object[]{this.getProject().getConfigurations().getByName("modCompileClasspathMapped")});
    }

    public void exec() {
        this.fileArg(((RegularFile)this.getInputJar().get()).getAsFile(), ((RegularFile)this.getOutputJar().get()).getAsFile(), ((RegularFile)this.getUnpickDefinitions().get()).getAsFile());
        this.fileArg(this.getConstantJar().getSingleFile());
        for (Path minecraftJar : this.getExtension().getMinecraftJars(MappingsNamespace.NAMED)) {
            this.fileArg(minecraftJar.toFile());
        }
        for (File file : this.getUnpickClasspath()) {
            this.fileArg(file);
        }
        this.writeUnpickLogConfig();
        this.systemProperty("java.util.logging.config.file", this.getDirectories().getUnpickLoggingConfigFile().getAbsolutePath());
        super.exec();
    }

    private void writeUnpickLogConfig() {
        try (InputStream is = UnpickJarTask.class.getClassLoader().getResourceAsStream("unpick-logging.properties");){
            Files.deleteIfExists(this.getDirectories().getUnpickLoggingConfigFile().toPath());
            Files.copy(is, this.getDirectories().getUnpickLoggingConfigFile().toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy unpick logging config", e);
        }
    }

    private void fileArg(File ... files) {
        for (File file : files) {
            this.args(new Object[]{file.getAbsolutePath()});
        }
    }

    @Internal
    protected LoomGradleExtension getExtension() {
        return LoomGradleExtension.get(this.getProject());
    }

    private LoomFiles getDirectories() {
        return this.getExtension().getFiles();
    }
}

