/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.task.CleanEclipseRunsTask;
import net.fabricmc.loom.task.DownloadAssetsTask;
import net.fabricmc.loom.task.ExtractNativesTask;
import net.fabricmc.loom.task.GenEclipseRunsTask;
import net.fabricmc.loom.task.GenIdeaProjectTask;
import net.fabricmc.loom.task.GenVsCodeProjectTask;
import net.fabricmc.loom.task.MigrateMappingsTask;
import net.fabricmc.loom.task.RunGameTask;
import net.fabricmc.loom.task.ValidateAccessWidenerTask;
import net.fabricmc.loom.task.launch.GenerateDLIConfigTask;
import net.fabricmc.loom.task.launch.GenerateLog4jConfigTask;
import net.fabricmc.loom.task.launch.GenerateRemapClasspathTask;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class LoomTasks
implements Runnable {
    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract TaskContainer getTasks();

    @Override
    public void run() {
        this.getTasks().register("migrateMappings", MigrateMappingsTask.class, t -> {
            t.setDescription("Migrates mappings to a new version.");
            t.getOutputs().upToDateWhen(o -> false);
        });
        this.getTasks().register("generateDLIConfig", GenerateDLIConfigTask.class, t -> {
            t.setDescription("Generate the DevLaunchInjector config file");
            t.mustRunAfter(new Object[]{this.getTasks().named("eclipse")});
            t.mustRunAfter(new Object[]{this.getTasks().named("idea")});
        });
        this.getTasks().register("generateLog4jConfig", GenerateLog4jConfigTask.class, t -> t.setDescription("Generate the log4j config file"));
        this.getTasks().register("generateRemapClasspath", GenerateRemapClasspathTask.class, t -> t.setDescription("Generate the remap classpath file"));
        this.getTasks().register("configureLaunch", task -> {
            task.dependsOn(new Object[]{this.getTasks().named("generateDLIConfig")});
            task.dependsOn(new Object[]{this.getTasks().named("generateLog4jConfig")});
            task.dependsOn(new Object[]{this.getTasks().named("generateRemapClasspath")});
            task.setDescription("Setup the required files to launch Minecraft");
            task.setGroup("fabric");
        });
        TaskProvider validateAccessWidener = this.getTasks().register("validateAccessWidener", ValidateAccessWidenerTask.class, t -> {
            t.setDescription("Validate all the rules in the access widener against the Minecraft jar");
            t.setGroup("verification");
        });
        this.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{validateAccessWidener}));
        this.registerIDETasks();
        this.registerRunTasks();
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
            if (extension.getMinecraftJarConfiguration().get() == MinecraftJarConfiguration.SERVER_ONLY) {
                return;
            }
            MinecraftVersionMeta versionInfo = extension.getMinecraftProvider().getVersionInfo();
            if (versionInfo == null) {
                return;
            }
            LoomTasks.registerClientSetupTasks(this.getTasks(), versionInfo.hasNativesToExtract());
        });
    }

    private void registerIDETasks() {
        this.getTasks().register("genIdeaWorkspace", GenIdeaProjectTask.class, t -> {
            t.setDescription("Generates an IntelliJ IDEA workspace from this project.");
            t.dependsOn(new Object[]{"idea", LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            t.setGroup("ide");
        });
        this.getTasks().register("genEclipseRuns", GenEclipseRunsTask.class, t -> {
            t.setDescription("Generates Eclipse run configurations for this project.");
            t.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            t.setGroup("ide");
        });
        this.getTasks().register("cleanEclipseRuns", CleanEclipseRunsTask.class, t -> {
            t.setDescription("Removes Eclipse run configurations for this project.");
            t.setGroup("ide");
        });
        this.getTasks().register("vscode", GenVsCodeProjectTask.class, t -> {
            t.setDescription("Generates VSCode launch configurations.");
            t.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(this.getProject())});
            t.setGroup("ide");
        });
    }

    private void registerRunTasks() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        Preconditions.checkArgument((extension.getRunConfigs().size() == 0 ? 1 : 0) != 0, (Object)"Run configurations must not be registered before loom");
        extension.getRunConfigs().whenObjectAdded(config -> {
            String configName = config.getName();
            String taskName = "run" + configName.substring(0, 1).toUpperCase() + configName.substring(1);
            this.getTasks().register(taskName, RunGameTask.class, new Object[]{config}).configure(t -> {
                t.setDescription("Starts the '" + config.getConfigName() + "' run configuration");
                t.dependsOn(new Object[]{config.getEnvironment().equals("client") ? "configureClientLaunch" : "configureLaunch"});
            });
        });
        extension.getRunConfigs().create("client", RunConfigSettings::client);
        extension.getRunConfigs().create("server", RunConfigSettings::server);
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            String taskName;
            switch ((MinecraftJarConfiguration)((Object)((Object)extension.getMinecraftJarConfiguration().get()))) {
                case SERVER_ONLY: {
                    String string = "client";
                    break;
                }
                case CLIENT_ONLY: {
                    String string = "server";
                    break;
                }
                default: {
                    String string = taskName = null;
                }
            }
            if (taskName == null) {
                return;
            }
            extension.getRunConfigs().removeIf(settings -> settings.getName().equals(taskName));
        });
    }

    private static void registerClientSetupTasks(TaskContainer tasks, boolean extractNatives) {
        tasks.register("downloadAssets", DownloadAssetsTask.class, t -> t.setDescription("Downloads required game assets for Minecraft."));
        if (extractNatives) {
            tasks.register("extractNatives", ExtractNativesTask.class, t -> t.setDescription("Extracts the Minecraft platform specific natives."));
        }
        tasks.register("configureClientLaunch", task -> {
            task.dependsOn(new Object[]{tasks.named("downloadAssets")});
            task.dependsOn(new Object[]{tasks.named("configureLaunch")});
            if (extractNatives) {
                task.dependsOn(new Object[]{tasks.named("extractNatives")});
            }
            task.setDescription("Setup the required files to launch the Minecraft client");
            task.setGroup("fabric");
        });
    }

    public static Provider<Task> getIDELaunchConfigureTaskName(Project project) {
        return project.provider(() -> {
            MinecraftJarConfiguration jarConfiguration = (MinecraftJarConfiguration)((Object)((Object)LoomGradleExtension.get(project).getMinecraftJarConfiguration().get()));
            String name = jarConfiguration == MinecraftJarConfiguration.SERVER_ONLY ? "configureLaunch" : "configureClientLaunch";
            return project.getTasks().getByName(name);
        });
    }
}

