/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.kotlin.remapping;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmLambda;
import kotlinx.metadata.KmPackage;
import kotlinx.metadata.jvm.JvmMetadataUtil;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import net.fabricmc.loom.kotlin.remapping.KotlinClassRemapper;
import net.fabricmc.loom.kotlin.remapping.KotlinMetadataRemappingClassVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u001c\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor;", "Lorg/objectweb/asm/tree/AnnotationNode;", "remapper", "Lorg/objectweb/asm/commons/Remapper;", "next", "Lorg/objectweb/asm/AnnotationVisitor;", "className", "", "(Lorg/objectweb/asm/commons/Remapper;Lorg/objectweb/asm/AnnotationVisitor;Ljava/lang/String;)V", "_name", "getClassName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNext", "()Lorg/objectweb/asm/AnnotationVisitor;", "readHeader", "Lkotlin/Metadata;", "validateKotlinClassHeader", "", "remapped", "original", "visit", "name", "value", "", "visitEnd", "writeClassHeader", "header", "fabric-loom"})
@SourceDebugExtension(value={"SMAP\nKotlinClassMetadataRemappingAnnotationVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassMetadataRemappingAnnotationVisitor.kt\nnet/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,157:1\n1855#2:158\n1856#2:163\n37#3,2:159\n37#3,2:161\n*S KotlinDebug\n*F\n+ 1 KotlinClassMetadataRemappingAnnotationVisitor.kt\nnet/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor\n*L\n114#1:158\n114#1:163\n118#1:159,2\n119#1:161,2\n*E\n"})
public final class KotlinClassMetadataRemappingAnnotationVisitor
extends AnnotationNode {
    @NotNull
    private final Remapper remapper;
    @NotNull
    private final AnnotationVisitor next;
    @Nullable
    private final String className;
    private final Logger logger;
    @Nullable
    private String _name;

    public KotlinClassMetadataRemappingAnnotationVisitor(@NotNull Remapper remapper, @NotNull AnnotationVisitor next, @Nullable String className) {
        Intrinsics.checkNotNullParameter((Object)remapper, (String)"remapper");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        super(589824, KotlinMetadataRemappingClassVisitor.Companion.getANNOTATION_DESCRIPTOR());
        this.remapper = remapper;
        this.next = next;
        this.className = className;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final AnnotationVisitor getNext() {
        return this.next;
    }

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    public void visit(@Nullable String name, @Nullable Object value) {
        super.visit(name, value);
        this._name = name;
    }

    public void visitEnd() {
        KotlinClassMetadata metadata;
        KotlinVersion currentMinorVersion;
        super.visitEnd();
        Metadata metadata2 = this.readHeader();
        if (metadata2 == null) {
            return;
        }
        Metadata header = metadata2;
        KotlinVersion headerVersion = new KotlinVersion(header.mv()[0], header.mv()[1], 0);
        if (!Intrinsics.areEqual((Object)headerVersion, (Object)(currentMinorVersion = new KotlinVersion(KotlinVersion.CURRENT.getMajor(), KotlinVersion.CURRENT.getMinor(), 0)))) {
            this.logger.info("Kotlin metadata for class (" + this.className + ") as it was built using a different major Kotlin version (" + header.mv()[0] + "." + header.mv()[1] + ".x) while the remapper is using (" + KotlinVersion.CURRENT + ").");
        }
        if ((metadata = KotlinClassMetadata.Companion.read(header)) instanceof KotlinClassMetadata.Class) {
            KmClass klass = ((KotlinClassMetadata.Class)metadata).toKmClass();
            klass = new KotlinClassRemapper(this.remapper).remap(klass);
            Metadata remapped = KotlinClassMetadata.Companion.writeClass(klass, header.mv(), header.xi()).getAnnotationData();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (metadata instanceof KotlinClassMetadata.SyntheticClass) {
            KmLambda klambda = ((KotlinClassMetadata.SyntheticClass)metadata).toKmLambda();
            if (klambda != null) {
                klambda = new KotlinClassRemapper(this.remapper).remap(klambda);
                Metadata remapped = KotlinClassMetadata.Companion.writeLambda(klambda, header.mv(), header.xi()).getAnnotationData();
                this.writeClassHeader(remapped);
                this.validateKotlinClassHeader(remapped, header);
            } else {
                this.accept(this.next);
            }
        } else if (metadata instanceof KotlinClassMetadata.FileFacade) {
            KmPackage kpackage = ((KotlinClassMetadata.FileFacade)metadata).toKmPackage();
            kpackage = new KotlinClassRemapper(this.remapper).remap(kpackage);
            Metadata remapped = KotlinClassMetadata.Companion.writeFileFacade(kpackage, header.mv(), header.xi()).getAnnotationData();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (metadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            KmPackage kpackage = ((KotlinClassMetadata.MultiFileClassPart)metadata).toKmPackage();
            kpackage = new KotlinClassRemapper(this.remapper).remap(kpackage);
            Metadata remapped = KotlinClassMetadata.Companion.writeMultiFileClassPart(kpackage, ((KotlinClassMetadata.MultiFileClassPart)metadata).getFacadeClassName(), ((KotlinClassMetadata.MultiFileClassPart)metadata).getAnnotationData().mv(), ((KotlinClassMetadata.MultiFileClassPart)metadata).getAnnotationData().xi()).getAnnotationData();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if ((metadata instanceof KotlinClassMetadata.MultiFileClassFacade ? true : metadata instanceof KotlinClassMetadata.Unknown) ? true : metadata == null) {
            this.accept(this.next);
        }
    }

    private final Metadata readHeader() {
        Integer kind = null;
        int[] metadataVersion = null;
        String[] data1 = null;
        String[] data2 = null;
        String extraString = null;
        String packageName = null;
        Integer extraInt = null;
        if (this.values == null) {
            return null;
        }
        List list = this.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)list, (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            Collection $this$toTypedArray$iv;
            List list2 = (List)element$iv;
            boolean bl = false;
            Object name = list2.get(0);
            Object value = list2.get(1);
            Object e = name;
            if (Intrinsics.areEqual(e, (Object)"k")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Int");
                kind = (Integer)value;
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"mv")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
                metadataVersion = CollectionsKt.toIntArray((Collection)((List)value));
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"d1")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                $this$toTypedArray$iv = (List)value;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                data1 = thisCollection$iv.toArray(new String[0]);
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"d2")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                $this$toTypedArray$iv = (List)value;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                data2 = thisCollection$iv.toArray(new String[0]);
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"xs")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                extraString = (String)value;
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"pn")) {
                Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                packageName = (String)value;
                continue;
            }
            if (!Intrinsics.areEqual(e, (Object)"xi")) continue;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Int");
            extraInt = (Integer)value;
        }
        return JvmMetadataUtil.Metadata(kind, metadataVersion, (String[])data1, (String[])data2, extraString, packageName, extraInt);
    }

    private final void writeClassHeader(Metadata header) {
        AnnotationNode newNode = new AnnotationNode(this.api, this.desc);
        List list = this.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.values");
        newNode.values = CollectionsKt.toMutableList((Collection)list);
        AnnotationNode $this$writeClassHeader_u24lambda_u241 = newNode;
        boolean bl = false;
        int n = $this$writeClassHeader_u24lambda_u241.values.size() + -1;
        int i = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                Object e;
                if (Intrinsics.areEqual(e = $this$writeClassHeader_u24lambda_u241.values.get(i), (Object)"k")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.k());
                } else if (Intrinsics.areEqual(e, (Object)"mv")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, ArraysKt.toList((int[])header.mv()));
                } else if (Intrinsics.areEqual(e, (Object)"d1")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, ArraysKt.toList((Object[])header.d1()));
                } else if (Intrinsics.areEqual(e, (Object)"d2")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, ArraysKt.toList((Object[])header.d2()));
                } else if (Intrinsics.areEqual(e, (Object)"xs")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.xs());
                } else if (Intrinsics.areEqual(e, (Object)"pn")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.pn());
                } else if (Intrinsics.areEqual(e, (Object)"xi")) {
                    $this$writeClassHeader_u24lambda_u241.values.set(i + 1, header.xi());
                }
                if (i == n2) break;
                i += 2;
            }
        }
        newNode.accept(this.next);
    }

    private final void validateKotlinClassHeader(Metadata remapped, Metadata original) {
        if (remapped.d2().length != original.d2().length) {
            this.logger.info("Kotlin class metadata size mismatch: data2 size does not match original in class " + this.className + ". New: " + remapped.d2().length + " Old: " + original.d2().length);
        }
    }
}

