/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.LoomDependencyManager;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.configuration.providers.mappings.IntermediaryMappingsProvider;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.LoomGradleExtensionApiImpl;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.extension.MixinExtensionImpl;
import net.fabricmc.loom.util.download.Download;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;

public class LoomGradleExtensionImpl
extends LoomGradleExtensionApiImpl
implements LoomGradleExtension {
    private final Project project;
    private final MixinExtension mixinApExtension;
    private final LoomFiles loomFiles;
    private final ConfigurableFileCollection unmappedMods;
    private final List<AccessWidenerFile> transitiveAccessWideners = new ArrayList<AccessWidenerFile>();
    private LoomDependencyManager dependencyManager;
    private MinecraftProvider minecraftProvider;
    private MappingConfiguration mappingConfiguration;
    private NamedMinecraftProvider<?> namedMinecraftProvider;
    private IntermediaryMinecraftProvider<?> intermediaryMinecraftProvider;
    private InstallerData installerData;
    private boolean refreshDeps;
    private Provider<Boolean> multiProjectOptimisation;

    public LoomGradleExtensionImpl(Project project, LoomFiles files) {
        super(project, files);
        this.project = project;
        this.mixinApExtension = (MixinExtension)project.getObjects().newInstance(MixinExtensionImpl.class, new Object[]{project});
        this.loomFiles = files;
        this.unmappedMods = project.files(new Object[0]);
        this.setIntermediateMappingsProvider(IntermediaryMappingsProvider.class, provider -> {
            provider.getIntermediaryUrl().convention(this.getIntermediaryUrl()).finalizeValueOnRead();
            provider.getRefreshDeps().set(project.provider(() -> LoomGradleExtension.get(project).refreshDeps()));
        });
        this.refreshDeps = this.manualRefreshDeps();
        this.multiProjectOptimisation = GradleUtils.getBooleanPropertyProvider(project, "fabric.loom.multiProjectOptimisation");
        if (this.refreshDeps) {
            project.getLogger().lifecycle("Refresh dependencies is in use, loom will be significantly slower.");
        }
    }

    @Override
    protected Project getProject() {
        return this.project;
    }

    @Override
    public LoomFiles getFiles() {
        return this.loomFiles;
    }

    @Override
    public void setDependencyManager(LoomDependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    @Override
    public LoomDependencyManager getDependencyManager() {
        return Objects.requireNonNull(this.dependencyManager, "Cannot get LoomDependencyManager before it has been setup");
    }

    @Override
    public MinecraftProvider getMinecraftProvider() {
        return Objects.requireNonNull(this.minecraftProvider, "Cannot get MinecraftProvider before it has been setup");
    }

    @Override
    public void setMinecraftProvider(MinecraftProvider minecraftProvider) {
        this.minecraftProvider = minecraftProvider;
    }

    @Override
    public MappingConfiguration getMappingConfiguration() {
        return Objects.requireNonNull(this.mappingConfiguration, "Cannot get MappingsProvider before it has been setup");
    }

    @Override
    public void setMappingConfiguration(MappingConfiguration mappingConfiguration) {
        this.mappingConfiguration = mappingConfiguration;
    }

    @Override
    public NamedMinecraftProvider<?> getNamedMinecraftProvider() {
        return Objects.requireNonNull(this.namedMinecraftProvider, "Cannot get NamedMinecraftProvider before it has been setup");
    }

    @Override
    public IntermediaryMinecraftProvider<?> getIntermediaryMinecraftProvider() {
        return Objects.requireNonNull(this.intermediaryMinecraftProvider, "Cannot get IntermediaryMinecraftProvider before it has been setup");
    }

    @Override
    public void setNamedMinecraftProvider(NamedMinecraftProvider<?> namedMinecraftProvider) {
        this.namedMinecraftProvider = namedMinecraftProvider;
    }

    @Override
    public void setIntermediaryMinecraftProvider(IntermediaryMinecraftProvider<?> intermediaryMinecraftProvider) {
        this.intermediaryMinecraftProvider = intermediaryMinecraftProvider;
    }

    @Override
    public FileCollection getMinecraftJarsCollection(MappingsNamespace mappingsNamespace) {
        return this.getProject().files(new Object[]{this.getProject().provider(() -> this.getProject().files(new Object[]{this.getMinecraftJars(mappingsNamespace).stream().map(Path::toFile).toList()}))});
    }

    @Override
    public ConfigurableFileCollection getUnmappedModCollection() {
        return this.unmappedMods;
    }

    @Override
    public void setInstallerData(InstallerData object) {
        this.installerData = object;
    }

    @Override
    public InstallerData getInstallerData() {
        return this.installerData;
    }

    @Override
    public boolean isRootProject() {
        return this.project.getRootProject() == this.project;
    }

    @Override
    public MixinExtension getMixin() {
        return this.mixinApExtension;
    }

    @Override
    public List<AccessWidenerFile> getTransitiveAccessWideners() {
        return this.transitiveAccessWideners;
    }

    @Override
    public void addTransitiveAccessWideners(List<AccessWidenerFile> accessWidenerFiles) {
        this.transitiveAccessWideners.addAll(accessWidenerFiles);
    }

    @Override
    public DownloadBuilder download(String url) {
        DownloadBuilder builder;
        try {
            builder = Download.create(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create downloader for: " + e);
        }
        if (this.project.getGradle().getStartParameter().isOffline()) {
            builder.offline();
        }
        if (this.manualRefreshDeps()) {
            builder.forceDownload();
        }
        return builder;
    }

    private boolean manualRefreshDeps() {
        return this.project.getGradle().getStartParameter().isRefreshDependencies() || Boolean.getBoolean("loom.refresh");
    }

    @Override
    public boolean refreshDeps() {
        return this.refreshDeps;
    }

    @Override
    public void setRefreshDeps(boolean refreshDeps) {
        this.refreshDeps = refreshDeps;
    }

    @Override
    public boolean multiProjectOptimisation() {
        return (Boolean)this.multiProjectOptimisation.getOrElse((Object)false);
    }

    @Override
    protected <T extends IntermediateMappingsProvider> void configureIntermediateMappingsProviderInternal(T provider) {
        provider.getMinecraftVersion().set(this.getProject().provider(() -> this.getMinecraftProvider().minecraftVersion()));
        provider.getMinecraftVersion().disallowChanges();
        provider.getDownloader().set(this::download);
        provider.getDownloader().disallowChanges();
    }
}

