/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.fernflower;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import net.fabricmc.fernflower.api.IFabricJavadocProvider;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;

public class TinyJavadocProvider
implements IFabricJavadocProvider {
    private final MappingTree mappingTree;

    public TinyJavadocProvider(File tinyFile) {
        this.mappingTree = TinyJavadocProvider.readMappings(tinyFile);
    }

    public String getClassDoc(StructClass structClass) {
        MappingTree.ClassMapping classMapping = this.mappingTree.getClass(structClass.qualifiedName);
        if (classMapping == null) {
            return null;
        }
        if (!TinyJavadocProvider.isRecord(structClass)) {
            return classMapping.getComment();
        }
        ArrayList<String> parts = new ArrayList<String>();
        if (classMapping.getComment() != null) {
            parts.add(classMapping.getComment());
        }
        boolean addedParam = false;
        for (StructRecordComponent component : structClass.getRecordComponents()) {
            String comment;
            MappingTree.FieldMapping fieldMapping = classMapping.getField(component.getName(), component.getDescriptor());
            if (fieldMapping == null || (comment = fieldMapping.getComment()) == null) continue;
            if (!addedParam && classMapping.getComment() != null) {
                parts.add("");
                addedParam = true;
            }
            parts.add(String.format("@param %s %s", fieldMapping.getName(MappingsNamespace.NAMED.toString()), comment));
        }
        if (parts.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", parts);
    }

    public String getFieldDoc(StructClass structClass, StructField structField) {
        if (TinyJavadocProvider.isRecord(structClass) && !TinyJavadocProvider.isStatic(structField)) {
            return null;
        }
        MappingTree.ClassMapping classMapping = this.mappingTree.getClass(structClass.qualifiedName);
        if (classMapping == null) {
            return null;
        }
        MappingTree.FieldMapping fieldMapping = classMapping.getField(structField.getName(), structField.getDescriptor());
        return fieldMapping != null ? fieldMapping.getComment() : null;
    }

    public String getMethodDoc(StructClass structClass, StructMethod structMethod) {
        MappingTree.ClassMapping classMapping = this.mappingTree.getClass(structClass.qualifiedName);
        if (classMapping == null) {
            return null;
        }
        MappingTree.MethodMapping methodMapping = classMapping.getMethod(structMethod.getName(), structMethod.getDescriptor());
        if (methodMapping != null) {
            ArrayList<String> parts = new ArrayList<String>();
            if (methodMapping.getComment() != null) {
                parts.add(methodMapping.getComment());
            }
            boolean addedParam = false;
            for (MappingTree.MethodArgMapping argMapping : methodMapping.getArgs()) {
                String comment = argMapping.getComment();
                if (comment == null) continue;
                if (!addedParam && methodMapping.getComment() != null) {
                    parts.add("");
                    addedParam = true;
                }
                parts.add(String.format("@param %s %s", argMapping.getName(MappingsNamespace.NAMED.toString()), comment));
            }
            if (parts.isEmpty()) {
                return null;
            }
            return String.join((CharSequence)"\n", parts);
        }
        return null;
    }

    private static MappingTree readMappings(File input) {
        MemoryMappingTree memoryMappingTree;
        block8: {
            BufferedReader reader = Files.newBufferedReader(input.toPath());
            try {
                MemoryMappingTree mappingTree = new MemoryMappingTree();
                MappingSourceNsSwitch nsSwitch = new MappingSourceNsSwitch((MappingVisitor)mappingTree, MappingsNamespace.NAMED.toString());
                MappingReader.read((Reader)reader, (MappingVisitor)nsSwitch);
                memoryMappingTree = mappingTree;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read mappings", e);
                }
            }
            reader.close();
        }
        return memoryMappingTree;
    }

    public static boolean isRecord(StructClass structClass) {
        return (structClass.getAccessFlags() & 0x10000) != 0;
    }

    public static boolean isStatic(StructField structField) {
        return (structField.getAccessFlags() & 8) != 0;
    }
}

