/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.fernflower;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.decompilers.fernflower.FernFlowerUtils;
import net.fabricmc.loom.decompilers.fernflower.FernflowerLogger;
import net.fabricmc.loom.decompilers.fernflower.ThreadSafeResultSaver;
import net.fabricmc.loom.decompilers.fernflower.TinyJavadocProvider;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public final class FabricFernFlowerDecompiler
implements LoomDecompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompile(Path compiledJar, Path sourcesDestination, Path linemapDestination, DecompilationMetadata metaData) {
        HashMap<String, TinyJavadocProvider> options = new HashMap<String, TinyJavadocProvider>(Map.of("dgs", "1", "bsm", "1", "rsy", "1", "log", "trace", "thr", String.valueOf(metaData.numberOfThreads()), "ind", "\t", "fabric:javadoc", new TinyJavadocProvider(metaData.javaDocs().toFile())));
        options.putAll(metaData.options());
        ThreadSafeResultSaver saver = new ThreadSafeResultSaver(sourcesDestination::toFile, linemapDestination::toFile);
        Fernflower ff = new Fernflower(FernFlowerUtils::getBytecode, (IResultSaver)saver, options, (IFernflowerLogger)new FernflowerLogger(metaData.logger()));
        for (Path library : metaData.libraries()) {
            ff.addLibrary(library.toFile());
        }
        ff.addSource(compiledJar.toFile());
        try {
            ff.decompileContext();
        }
        finally {
            ff.clearContext();
        }
    }
}

