/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cfr;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import net.fabricmc.loom.util.IOStringConsumer;
import org.benf.cfr.reader.api.OutputSinkFactory;
import org.benf.cfr.reader.api.SinkReturns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFRSinkFactory
implements OutputSinkFactory {
    private static final Logger ERROR_LOGGER = LoggerFactory.getLogger(CFRSinkFactory.class);
    private final JarOutputStream outputStream;
    private final IOStringConsumer logger;
    private final Set<String> addedDirectories = new HashSet<String>();
    private final Map<String, Map<Integer, Integer>> lineMap = new TreeMap<String, Map<Integer, Integer>>();

    public CFRSinkFactory(JarOutputStream outputStream, IOStringConsumer logger) {
        this.outputStream = outputStream;
        this.logger = logger;
    }

    @Override
    public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> available) {
        return switch (sinkType) {
            case OutputSinkFactory.SinkType.JAVA -> Collections.singletonList(OutputSinkFactory.SinkClass.DECOMPILED);
            case OutputSinkFactory.SinkType.LINENUMBER -> Collections.singletonList(OutputSinkFactory.SinkClass.LINE_NUMBER_MAPPING);
            default -> Collections.emptyList();
        };
    }

    @Override
    public <T> OutputSinkFactory.Sink<T> getSink(OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
        return switch (sinkType) {
            case OutputSinkFactory.SinkType.JAVA -> this.decompiledSink();
            case OutputSinkFactory.SinkType.LINENUMBER -> this.lineNumberMappingSink();
            case OutputSinkFactory.SinkType.EXCEPTION -> e -> ERROR_LOGGER.error((String)e);
            default -> null;
        };
    }

    private OutputSinkFactory.Sink<SinkReturns.Decompiled> decompiledSink() {
        return sinkable -> {
            Object filename = sinkable.getPackageName().replace('.', '/');
            if (!((String)filename).isEmpty()) {
                filename = (String)filename + "/";
            }
            filename = (String)filename + sinkable.getClassName() + ".java";
            byte[] data = sinkable.getJava().getBytes(Charsets.UTF_8);
            this.writeToJar((String)filename, data);
        };
    }

    private OutputSinkFactory.Sink<SinkReturns.LineNumberMapping> lineNumberMappingSink() {
        return sinkable -> {
            String className = sinkable.getClassName();
            NavigableMap<Integer, Integer> classFileMappings = sinkable.getClassFileMappings();
            NavigableMap<Integer, Integer> mappings = sinkable.getMappings();
            if (classFileMappings == null || mappings == null) {
                return;
            }
            for (Map.Entry entry : mappings.entrySet()) {
                Integer dstLineNumber = (Integer)entry.getValue();
                Integer srcLineNumber = (Integer)classFileMappings.get(entry.getKey());
                if (srcLineNumber == null || dstLineNumber == null) continue;
                this.lineMap.computeIfAbsent(className, c -> new TreeMap()).put(srcLineNumber, dstLineNumber);
            }
        };
    }

    private synchronized void writeToJar(String filename, byte[] data) {
        String[] path = filename.split("/");
        Object pathPart = "";
        for (int i = 0; i < path.length - 1; ++i) {
            if (!this.addedDirectories.add((String)(pathPart = (String)pathPart + path[i] + "/"))) continue;
            JarEntry entry = new JarEntry((String)pathPart);
            entry.setTime(new Date().getTime());
            try {
                this.outputStream.putNextEntry(entry);
                this.outputStream.closeEntry();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        JarEntry entry = new JarEntry(filename);
        entry.setTime(new Date().getTime());
        entry.setSize(data.length);
        try {
            this.logger.accept("Writing: " + filename);
            this.outputStream.putNextEntry(entry);
            this.outputStream.write(data);
            this.outputStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Map<Integer, Integer>> getLineMap() {
        return Collections.unmodifiableMap(this.lineMap);
    }
}

