/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.processors.ProcessorContextImpl;
import net.fabricmc.loom.configuration.providers.minecraft.MergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SplitMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import org.gradle.api.Project;

public abstract class ProcessedNamedMinecraftProvider<M extends MinecraftProvider, P extends NamedMinecraftProvider<M>>
extends NamedMinecraftProvider<M> {
    private final P parentMinecraftProvider;
    private final MinecraftJarProcessorManager jarProcessorManager;

    public ProcessedNamedMinecraftProvider(P parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
        super(((AbstractMappedMinecraftProvider)parentMinecraftProvide).getConfigContext(), ((AbstractMappedMinecraftProvider)parentMinecraftProvide).getMinecraftProvider());
        this.parentMinecraftProvider = parentMinecraftProvide;
        this.jarProcessorManager = Objects.requireNonNull(jarProcessorManager);
    }

    @Override
    public void provide(boolean applyDependencies) throws Exception {
        ((AbstractMappedMinecraftProvider)this.parentMinecraftProvider).provide(false);
        boolean requiresProcessing = this.parentMinecraftProvider.getMinecraftJars().stream().map(this::getProcessedPath).anyMatch(this.jarProcessorManager::requiresProcessingJar);
        if (requiresProcessing) {
            this.processJars();
        }
        if (applyDependencies) {
            this.applyDependencies();
        }
    }

    @Override
    public AbstractMappedMinecraftProvider.MavenScope getMavenScope() {
        return AbstractMappedMinecraftProvider.MavenScope.LOCAL;
    }

    private void processJars() throws IOException {
        for (MinecraftJar minecraftJar : this.parentMinecraftProvider.getMinecraftJars()) {
            MinecraftJar outputJar = this.getProcessedJar(minecraftJar);
            this.deleteSimilarJars(outputJar.getPath());
            LocalMavenHelper mavenHelper = this.getMavenHelper(minecraftJar.getName());
            Path outputPath = mavenHelper.copyToMaven(minecraftJar.getPath(), null);
            this.jarProcessorManager.processJar(outputPath, new ProcessorContextImpl(this.configContext, minecraftJar));
        }
    }

    private void applyDependencies() {
        List<String> dependencyTargets = ((AbstractMappedMinecraftProvider)this.parentMinecraftProvider).getDependencyTargets();
        if (dependencyTargets.isEmpty()) {
            return;
        }
        MinecraftSourceSets.get(this.getProject()).applyDependencies((configuration, name) -> this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation((String)name)), dependencyTargets);
    }

    private void deleteSimilarJars(Path jar) throws IOException {
        Files.deleteIfExists(jar);
        Path parent = jar.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            return;
        }
        for (Path path2 : Files.list(parent).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().startsWith(jar.getFileName().toString().replace(".jar", ""))).toList()) {
            Files.deleteIfExists(path2);
        }
    }

    @Override
    protected String getName(String name) {
        Project project = this.getProject();
        if (project.getRootProject() == project) {
            return "minecraft-%s-project-root".formatted(name).toLowerCase(Locale.ROOT);
        }
        String projectPath = project.getPath().replace(':', '@');
        return "minecraft-%s-project-%s".formatted(name, projectPath).toLowerCase(Locale.ROOT);
    }

    @Override
    public Path getJar(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractMappedMinecraftProvider.RemappedJars> getRemappedJars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<MinecraftJar> getMinecraftJars() {
        return this.getParentMinecraftProvider().getMinecraftJars().stream().map(this::getProcessedJar).toList();
    }

    public P getParentMinecraftProvider() {
        return this.parentMinecraftProvider;
    }

    private Path getProcessedPath(MinecraftJar minecraftJar) {
        LocalMavenHelper mavenHelper = this.getMavenHelper(minecraftJar.getName());
        return mavenHelper.getOutputFile(null);
    }

    public MinecraftJar getProcessedJar(MinecraftJar minecraftJar) {
        return minecraftJar.forPath(this.getProcessedPath(minecraftJar));
    }

    public static final class SingleJarImpl
    extends ProcessedNamedMinecraftProvider<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl>
    implements MappedMinecraftProvider.SingleJar {
        private final SingleJarEnvType env;

        private SingleJarImpl(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager, SingleJarEnvType env) {
            super(parentMinecraftProvide, jarProcessorManager);
            this.env = env;
        }

        public static SingleJarImpl server(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            return new SingleJarImpl(parentMinecraftProvide, jarProcessorManager, SingleJarEnvType.SERVER);
        }

        public static SingleJarImpl client(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            return new SingleJarImpl(parentMinecraftProvide, jarProcessorManager, SingleJarEnvType.CLIENT);
        }

        @Override
        public MinecraftJar getEnvOnlyJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.SingleJarImpl)this.getParentMinecraftProvider()).getEnvOnlyJar());
        }

        @Override
        public SingleJarEnvType env() {
            return this.env;
        }
    }

    public static final class SplitImpl
    extends ProcessedNamedMinecraftProvider<SplitMinecraftProvider, NamedMinecraftProvider.SplitImpl>
    implements MappedMinecraftProvider.Split {
        public SplitImpl(NamedMinecraftProvider.SplitImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvide, jarProcessorManager);
        }

        @Override
        public MinecraftJar getCommonJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.SplitImpl)this.getParentMinecraftProvider()).getCommonJar());
        }

        @Override
        public MinecraftJar getClientOnlyJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.SplitImpl)this.getParentMinecraftProvider()).getClientOnlyJar());
        }
    }

    public static final class MergedImpl
    extends ProcessedNamedMinecraftProvider<MergedMinecraftProvider, NamedMinecraftProvider.MergedImpl>
    implements MappedMinecraftProvider.Merged {
        public MergedImpl(NamedMinecraftProvider.MergedImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvide, jarProcessorManager);
        }

        @Override
        public MinecraftJar getMergedJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.MergedImpl)this.getParentMinecraftProvider()).getMergedJar());
        }
    }
}

