/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;

public interface MappedMinecraftProvider {
    default public List<Path> getMinecraftJarPaths() {
        return this.getMinecraftJars().stream().map(MinecraftJar::getPath).toList();
    }

    public List<MinecraftJar> getMinecraftJars();

    public static interface SingleJar
    extends ProviderImpl {
        public SingleJarEnvType env();

        default public String envName() {
            return "%sOnly".formatted(new Object[]{this.env()});
        }

        default public MinecraftJar getEnvOnlyJar() {
            return this.env().getJar().apply(this.getJar(this.envName()));
        }

        @Override
        default public List<MinecraftJar> getMinecraftJars() {
            return List.of(this.getEnvOnlyJar());
        }
    }

    public static interface Split
    extends ProviderImpl {
        public static final String COMMON = "common";
        public static final String CLIENT_ONLY = "clientOnly";

        default public MinecraftJar getCommonJar() {
            return new MinecraftJar.Common(this.getJar(COMMON));
        }

        default public MinecraftJar getClientOnlyJar() {
            return new MinecraftJar.ClientOnly(this.getJar(CLIENT_ONLY));
        }

        @Override
        default public List<MinecraftJar> getMinecraftJars() {
            return List.of(this.getCommonJar(), this.getClientOnlyJar());
        }
    }

    public static interface Merged
    extends ProviderImpl {
        public static final String MERGED = "merged";

        default public MinecraftJar getMergedJar() {
            return new MinecraftJar.Merged(this.getJar(MERGED));
        }

        @Override
        default public List<MinecraftJar> getMinecraftJars() {
            return List.of(this.getMergedJar());
        }
    }

    public static interface ProviderImpl
    extends MappedMinecraftProvider {
        public Path getJar(String var1);
    }
}

