/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.SignatureFixerApplyVisitor;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.util.SidedClassVisitor;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public abstract class AbstractMappedMinecraftProvider<M extends MinecraftProvider>
implements MappedMinecraftProvider.ProviderImpl {
    protected final M minecraftProvider;
    protected final ConfigContext configContext;
    protected final LoomGradleExtension extension;

    public AbstractMappedMinecraftProvider(ConfigContext configContext, M minecraftProvider) {
        this.configContext = configContext;
        this.minecraftProvider = minecraftProvider;
        this.extension = configContext.extension();
    }

    public abstract MappingsNamespace getTargetNamespace();

    public abstract List<RemappedJars> getRemappedJars();

    public List<String> getDependencyTargets() {
        return Collections.emptyList();
    }

    public void provide(boolean applyDependencies) throws Exception {
        List<RemappedJars> remappedJars = this.getRemappedJars();
        assert (!remappedJars.isEmpty());
        if (!this.areOutputsValid(remappedJars) || this.extension.refreshDeps()) {
            try {
                this.remapInputs(remappedJars);
            }
            catch (Throwable t) {
                this.cleanOutputs(remappedJars);
                throw new RuntimeException("Failed to remap minecraft", t);
            }
        }
        if (applyDependencies) {
            List<String> dependencyTargets = this.getDependencyTargets();
            if (dependencyTargets.isEmpty()) {
                return;
            }
            MinecraftSourceSets.get(this.getProject()).applyDependencies((configuration, name) -> this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation((String)name)), dependencyTargets);
        }
    }

    @Override
    public Path getJar(String name) {
        return this.getMavenHelper(name).getOutputFile(null);
    }

    public abstract MavenScope getMavenScope();

    public LocalMavenHelper getMavenHelper(String name) {
        return new LocalMavenHelper("net.minecraft", this.getName(name), this.getVersion(), null, this.getMavenScope().getRoot(this.extension));
    }

    protected String getName(String name) {
        String computedName = "minecraft-" + name;
        if (this.getTargetNamespace() != MappingsNamespace.NAMED) {
            computedName = this.getTargetNamespace().name() + "-" + name;
        }
        return computedName.toLowerCase(Locale.ROOT);
    }

    protected String getVersion() {
        return "%s-%s".formatted(this.extension.getMinecraftProvider().minecraftVersion(), this.extension.getMappingConfiguration().mappingsIdentifier());
    }

    protected String getDependencyNotation(String name) {
        return "net.minecraft:%s:%s".formatted(this.getName(name), this.getVersion());
    }

    private boolean areOutputsValid(List<RemappedJars> remappedJars) {
        for (RemappedJars remappedJar : remappedJars) {
            if (this.getMavenHelper(remappedJar.name()).exists(null)) continue;
            return false;
        }
        return true;
    }

    private void remapInputs(List<RemappedJars> remappedJars) throws IOException {
        this.cleanOutputs(remappedJars);
        for (RemappedJars remappedJar : remappedJars) {
            this.remapJar(remappedJar);
        }
    }

    private void remapJar(RemappedJars remappedJars) throws IOException {
        MappingConfiguration mappingConfiguration = this.extension.getMappingConfiguration();
        String fromM = remappedJars.sourceNamespace().toString();
        String toM = this.getTargetNamespace().toString();
        Files.deleteIfExists(remappedJars.outputJarPath());
        Map<String, String> remappedSignatures = SignatureFixerApplyVisitor.getRemappedSignatures(this.getTargetNamespace() == MappingsNamespace.INTERMEDIARY, mappingConfiguration, this.getProject(), this.configContext.serviceManager(), toM);
        TinyRemapper remapper = TinyRemapperHelper.getTinyRemapper(this.getProject(), this.configContext.serviceManager(), fromM, toM, true, builder -> {
            builder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new SignatureFixerApplyVisitor(remappedSignatures));
            this.configureRemapper(remappedJars, (TinyRemapper.Builder)builder);
        });
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(remappedJars.outputJarPath()).build();){
            outputConsumer.addNonClassFiles(remappedJars.inputJar());
            remapper.readClassPath(TinyRemapperHelper.getMinecraftCompileLibraries(this.getProject()));
            for (Path path : remappedJars.remapClasspath()) {
                remapper.readClassPath(new Path[]{path});
            }
            remapper.readInputs(new Path[]{remappedJars.inputJar()});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap JAR " + remappedJars.inputJar() + " with mappings from " + mappingConfiguration.tinyMappings, e);
        }
        finally {
            remapper.finish();
        }
        this.getMavenHelper(remappedJars.name()).savePom();
    }

    protected void configureRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
    }

    public static void configureSplitRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
        MinecraftJar outputJar = remappedJars.outputJar();
        assert (!outputJar.isMerged());
        if (outputJar.includesClient()) {
            assert (!outputJar.includesServer());
            tinyRemapperBuilder.extraPostApplyVisitor(SidedClassVisitor.CLIENT);
        }
    }

    private void cleanOutputs(List<RemappedJars> remappedJars) throws IOException {
        for (RemappedJars remappedJar : remappedJars) {
            Files.deleteIfExists(remappedJar.outputJarPath());
        }
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public Project getProject() {
        return this.getConfigContext().project();
    }

    public M getMinecraftProvider() {
        return this.minecraftProvider;
    }

    public static enum MavenScope {
        LOCAL(LoomFiles::getLocalMinecraftRepo),
        GLOBAL(LoomFiles::getGlobalMinecraftRepo);

        private final Function<LoomFiles, File> fileFunction;

        private MavenScope(Function<LoomFiles, File> fileFunction) {
            this.fileFunction = fileFunction;
        }

        public Path getRoot(LoomGradleExtension extension) {
            return this.fileFunction.apply(extension.getFiles()).toPath();
        }
    }

    public record RemappedJars(Path inputJar, MinecraftJar outputJar, MappingsNamespace sourceNamespace, Path[] remapClasspath) {
        public Path outputJarPath() {
            return this.outputJar().getPath();
        }

        public String name() {
            return this.outputJar().getName();
        }
    }
}

