/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MinecraftJar {
    private final Path path;
    private final boolean merged;
    private final boolean client;
    private final boolean server;
    private final String name;

    protected MinecraftJar(Path path, boolean merged, boolean client, boolean server, String name) {
        this.path = Objects.requireNonNull(path);
        this.merged = merged;
        this.client = client;
        this.server = server;
        this.name = name;
    }

    public Path getPath() {
        return this.path;
    }

    public File toFile() {
        return this.getPath().toFile();
    }

    public boolean isMerged() {
        return this.merged;
    }

    public boolean includesClient() {
        return this.client;
    }

    public boolean includesServer() {
        return this.server;
    }

    public String getName() {
        return this.name;
    }

    public abstract MinecraftJar forPath(Path var1);

    public static final class ClientOnly
    extends MinecraftJar {
        public ClientOnly(Path path) {
            super(path, false, true, false, "clientOnly");
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new ClientOnly(path);
        }
    }

    public static final class ServerOnly
    extends MinecraftJar {
        public ServerOnly(Path path) {
            super(path, false, false, true, "serverOnly");
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new ServerOnly(path);
        }
    }

    public static final class Common
    extends MinecraftJar {
        public Common(Path path) {
            super(path, false, false, true, "common");
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new Common(path);
        }
    }

    public static final class Merged
    extends MinecraftJar {
        public Merged(Path path) {
            super(path, true, true, true, "merged");
        }

        @Override
        public MinecraftJar forPath(Path path) {
            return new Merged(path);
        }
    }
}

