/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.download.DownloadBuilder;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntermediaryMappingsProvider
extends IntermediateMappingsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateMappingsProvider.class);

    public abstract Property<String> getIntermediaryUrl();

    public abstract Property<Boolean> getRefreshDeps();

    @Override
    public void provide(Path tinyMappings) throws IOException {
        if (Files.exists(tinyMappings, new LinkOption[0]) && !((Boolean)this.getRefreshDeps().get()).booleanValue()) {
            return;
        }
        Path intermediaryJarPath = Files.createTempFile(this.getName(), ".jar", new FileAttribute[0]);
        String encodedMcVersion = UrlEscapers.urlFragmentEscaper().escape((String)this.getMinecraftVersion().get());
        String url = ((String)this.getIntermediaryUrl().get()).formatted(encodedMcVersion);
        LOGGER.info("Downloading intermediary from {}", (Object)url);
        Files.deleteIfExists(tinyMappings);
        Files.deleteIfExists(intermediaryJarPath);
        ((DownloadBuilder)((Function)this.getDownloader().get()).apply(url)).defaultCache().downloadPath(intermediaryJarPath);
        MappingConfiguration.extractMappings(intermediaryJarPath, tinyMappings);
    }

    @NotNull
    public String getName() {
        return "intermediary-v2";
    }
}

