/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.io.File;
import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.decompile.DecompileConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.task.UnpickJarTask;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;

public final class SplitDecompileConfiguration
extends DecompileConfiguration<MappedMinecraftProvider.Split> {
    public SplitDecompileConfiguration(ConfigContext configContext, MappedMinecraftProvider.Split minecraftProvider) {
        super(configContext, minecraftProvider);
    }

    @Override
    public void afterEvaluation() {
        File commonJarToDecompile = ((MappedMinecraftProvider.Split)this.minecraftProvider).getCommonJar().toFile();
        File clientOnlyJarToDecompile = ((MappedMinecraftProvider.Split)this.minecraftProvider).getClientOnlyJar().toFile();
        TaskProvider<UnpickJarTask> unpickCommonJar = null;
        TaskProvider<UnpickJarTask> unpickClientOnlyJar = null;
        if (this.mappingConfiguration.hasUnpickDefinitions()) {
            commonJarToDecompile = new File(this.extension.getMappingConfiguration().mappingsWorkingDir().toFile(), "minecraft-common-unpicked.jar");
            clientOnlyJarToDecompile = new File(this.extension.getMappingConfiguration().mappingsWorkingDir().toFile(), "minecraft-clientonly-unpicked.jar");
            unpickCommonJar = this.createUnpickJarTask("unpickCommonJar", ((MappedMinecraftProvider.Split)this.minecraftProvider).getCommonJar().toFile(), commonJarToDecompile);
            unpickClientOnlyJar = this.createUnpickJarTask("unpickClientOnlyJar", ((MappedMinecraftProvider.Split)this.minecraftProvider).getClientOnlyJar().toFile(), clientOnlyJarToDecompile);
        }
        File commonJar = commonJarToDecompile;
        File clientOnlyJar = clientOnlyJarToDecompile;
        TaskProvider<UnpickJarTask> unpickCommonJarTask = unpickCommonJar;
        TaskProvider<UnpickJarTask> unpickClientOnlyJarTask = unpickClientOnlyJar;
        TaskProvider<Task> commonDecompileTask = this.createDecompileTasks("Common", (Action<GenerateSourcesTask>)((Action)task -> {
            task.getInputJar().set(commonJar);
            task.getRuntimeJar().set(((MappedMinecraftProvider.Split)this.minecraftProvider).getCommonJar().toFile());
            if (unpickCommonJarTask != null) {
                task.dependsOn(new Object[]{unpickCommonJarTask});
            }
        }));
        TaskProvider<Task> clientOnlyDecompileTask = this.createDecompileTasks("ClientOnly", (Action<GenerateSourcesTask>)((Action)task -> {
            task.getInputJar().set(clientOnlyJar);
            task.getRuntimeJar().set(((MappedMinecraftProvider.Split)this.minecraftProvider).getClientOnlyJar().toFile());
            if (unpickCommonJarTask != null) {
                task.dependsOn(new Object[]{unpickClientOnlyJarTask});
            }
            task.mustRunAfter(new Object[]{commonDecompileTask});
        }));
        for (DecompilerOptions options : this.extension.getDecompilerOptions()) {
            String decompilerName = options.getFormattedName();
            this.project.getTasks().register("genSourcesWith" + decompilerName, task -> {
                task.setDescription("Decompile minecraft using %s.".formatted(decompilerName));
                task.setGroup("fabric");
                task.dependsOn(new Object[]{this.project.getTasks().named("gen%sSourcesWith%s".formatted("Common", decompilerName))});
                task.dependsOn(new Object[]{this.project.getTasks().named("gen%sSourcesWith%s".formatted("ClientOnly", decompilerName))});
            });
        }
        this.project.getTasks().register("genSources", task -> {
            task.setDescription("Decompile minecraft using the default decompiler.");
            task.setGroup("fabric");
            task.dependsOn(new Object[]{commonDecompileTask});
            task.dependsOn(new Object[]{clientOnlyDecompileTask});
        });
    }

    private TaskProvider<Task> createDecompileTasks(String name, Action<GenerateSourcesTask> configureAction) {
        this.extension.getDecompilerOptions().forEach(options -> {
            String decompilerName = options.getFormattedName();
            String taskName = "gen%sSourcesWith%s".formatted(name, decompilerName);
            this.project.getTasks().register(taskName, GenerateSourcesTask.class, new Object[]{options}).configure(task -> {
                configureAction.execute((Object)task);
                task.dependsOn(new Object[]{this.project.getTasks().named("validateAccessWidener")});
                task.setDescription("Decompile minecraft using %s.".formatted(decompilerName));
                task.setGroup("fabric");
            });
        });
        return this.project.getTasks().register("gen%sSources".formatted(name), task -> {
            task.setDescription("Decompile minecraft (%s) using the default decompiler.".formatted(name));
            task.setGroup("fabric");
            task.dependsOn(new Object[]{this.project.getTasks().named("gen%sSourcesWithCfr".formatted(name))});
        });
    }
}

