/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.decompile.DecompileConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.GenerateSourcesTask;

public class SingleJarDecompileConfiguration
extends DecompileConfiguration<MappedMinecraftProvider> {
    public SingleJarDecompileConfiguration(ConfigContext configContext, MappedMinecraftProvider minecraftProvider) {
        super(configContext, minecraftProvider);
    }

    @Override
    public final void afterEvaluation() {
        File namedJar;
        List<Path> minecraftJars = this.minecraftProvider.getMinecraftJarPaths();
        assert (minecraftJars.size() == 1);
        File mappedJar = namedJar = minecraftJars.get(0).toFile();
        if (this.mappingConfiguration.hasUnpickDefinitions()) {
            File outputJar = new File(this.extension.getMappingConfiguration().mappingsWorkingDir().toFile(), "minecraft-unpicked.jar");
            this.createUnpickJarTask("unpickJar", namedJar, outputJar);
            mappedJar = outputJar;
        }
        File inputJar = mappedJar;
        LoomGradleExtension.get(this.project).getDecompilerOptions().forEach(options -> {
            String decompilerName = options.getFormattedName();
            String taskName = "genSourcesWith" + decompilerName;
            this.project.getTasks().register(taskName, GenerateSourcesTask.class, new Object[]{options}).configure(task -> {
                task.getInputJar().set(inputJar);
                task.getRuntimeJar().set(namedJar);
                task.dependsOn(new Object[]{this.project.getTasks().named("validateAccessWidener")});
                task.setDescription("Decompile minecraft using %s.".formatted(decompilerName));
                task.setGroup("fabric");
                if (this.mappingConfiguration.hasUnpickDefinitions()) {
                    task.dependsOn(new Object[]{this.project.getTasks().named("unpickJar")});
                }
            });
        });
        this.project.getTasks().register("genSources", task -> {
            task.setDescription("Decompile minecraft using the default decompiler.");
            task.setGroup("fabric");
            task.dependsOn(new Object[]{this.project.getTasks().named("genSourcesWithCfr")});
        });
    }
}

