/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.decompile;

import java.io.File;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.UnpickJarTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

public abstract class DecompileConfiguration<T extends MappedMinecraftProvider> {
    protected final Project project;
    protected final T minecraftProvider;
    protected final LoomGradleExtension extension;
    protected final MappingConfiguration mappingConfiguration;

    public DecompileConfiguration(ConfigContext configContext, T minecraftProvider) {
        this.project = configContext.project();
        this.minecraftProvider = minecraftProvider;
        this.extension = configContext.extension();
        this.mappingConfiguration = this.extension.getMappingConfiguration();
    }

    public abstract void afterEvaluation();

    protected final TaskProvider<UnpickJarTask> createUnpickJarTask(String name, File inputJar, File outputJar) {
        return this.project.getTasks().register(name, UnpickJarTask.class, unpickJarTask -> {
            unpickJarTask.getUnpickDefinitions().set(this.mappingConfiguration.getUnpickDefinitionsFile());
            unpickJarTask.getInputJar().set(inputJar);
            unpickJarTask.getOutputJar().set(outputJar);
        });
    }
}

