/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import com.google.gson.JsonObject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public record InstallerData(String version, JsonObject installerJson) {
    public void applyToProject(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getInstallerData() != null) {
            throw new IllegalStateException("Already applied installer data");
        }
        extension.setInstallerData(this);
        JsonObject libraries = this.installerJson.get("libraries").getAsJsonObject();
        Configuration loaderDepsConfig = project.getConfigurations().getByName("loaderLibraries");
        Configuration apDepsConfig = project.getConfigurations().getByName("annotationProcessor");
        libraries.get("common").getAsJsonArray().forEach(jsonElement -> {
            String name = jsonElement.getAsJsonObject().get("name").getAsString();
            project.getLogger().debug("Adding dependency ({}) from installer JSON", (Object)name);
            ExternalModuleDependency modDep = (ExternalModuleDependency)project.getDependencies().create((Object)name);
            modDep.setTransitive(false);
            loaderDepsConfig.getDependencies().add((Object)modDep);
            if (!IdeaUtils.isIdeaSync() && ((Boolean)extension.getMixin().getUseLegacyMixinAp().get()).booleanValue()) {
                apDepsConfig.getDependencies().add((Object)modDep);
            }
            if (jsonElement.getAsJsonObject().has("url") && !project.getGradle().getPlugins().hasPlugin(LoomRepositoryPlugin.class)) {
                String url = jsonElement.getAsJsonObject().get("url").getAsString();
                long count = project.getRepositories().stream().filter(artifactRepository -> artifactRepository instanceof MavenArtifactRepository).map(artifactRepository -> (MavenArtifactRepository)artifactRepository).filter(mavenArtifactRepository -> mavenArtifactRepository.getUrl().toString().equalsIgnoreCase(url)).count();
                if (count == 0L) {
                    project.getRepositories().maven(mavenArtifactRepository -> mavenArtifactRepository.setUrl((Object)jsonElement.getAsJsonObject().get("url").getAsString()));
                }
            }
        });
    }
}

