/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.bootstrap;

import java.util.ArrayList;
import net.fabricmc.loom.bootstrap.BootstrappedPlugin;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginAware;
import org.gradle.util.GradleVersion;

public class LoomGradlePluginBootstrap
implements Plugin<PluginAware> {
    private static final String MIN_SUPPORTED_GRADLE_VERSION = "8.1";
    private static final int MIN_SUPPORTED_MAJOR_JAVA_VERSION = 17;
    private static final int MIN_SUPPORTED_MAJOR_IDEA_VERSION = 2021;
    private static final String PLUGIN_CLASS_NAME = "net.fabricmc.loom.LoomGradlePlugin";
    private static final String IDEA_VERSION_PROP_KEY = "idea.version";

    public void apply(PluginAware pluginAware) {
        if (pluginAware instanceof Project) {
            Project project = (Project)pluginAware;
            if (project.findProperty("fabric.loom.skip-env-validation") == null) {
                this.validateEnvironment();
            } else {
                project.getLogger().lifecycle("Loom environment validation disabled. Please re-enable before reporting any issues.");
            }
        }
        this.getActivePlugin().apply(pluginAware);
    }

    private void validateEnvironment() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!LoomGradlePluginBootstrap.isValidGradleRuntime()) {
            errors.add(String.format("You are using an outdated version of Gradle (%s). Gradle %s or higher is required.", GradleVersion.current().getVersion(), MIN_SUPPORTED_GRADLE_VERSION));
        }
        if (!LoomGradlePluginBootstrap.isValidJavaRuntime()) {
            errors.add(String.format("You are using an outdated version of Java (%s). Java %d or higher is required.", JavaVersion.current().getMajorVersion(), 17));
            if (Boolean.getBoolean("idea.active")) {
                errors.add("You can change the Java version in the Gradle settings dialog.");
            } else {
                String javaHome = System.getenv("JAVA_HOME");
                if (javaHome != null) {
                    errors.add(String.format("The JAVA_HOME environment variable is currently set to (%s).", javaHome));
                }
            }
        }
        if (!LoomGradlePluginBootstrap.isValidIdeaRuntime()) {
            errors.add(String.format("You are using an outdated version of intellij idea (%s). Intellij idea %d or higher is required.", System.getProperty(IDEA_VERSION_PROP_KEY), 2021));
        }
        if (!errors.isEmpty()) {
            throw new UnsupportedOperationException(String.join((CharSequence)"\n", errors));
        }
    }

    private static boolean isValidJavaRuntime() {
        return JavaVersion.current().compareTo((Enum)JavaVersion.toVersion((Object)17)) >= 0;
    }

    private static boolean isValidGradleRuntime() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)MIN_SUPPORTED_GRADLE_VERSION)) >= 0;
    }

    private static boolean isValidIdeaRuntime() {
        String version = System.getProperty(IDEA_VERSION_PROP_KEY);
        if (version == null) {
            return true;
        }
        int ideaYear = Integer.parseInt(version.substring(0, version.indexOf(".")));
        return ideaYear >= 2021;
    }

    BootstrappedPlugin getActivePlugin() {
        try {
            return (BootstrappedPlugin)Class.forName(PLUGIN_CLASS_NAME).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bootstrap loom", e);
        }
    }
}

