/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;

public class FabricModJsonHelpers {
    public static List<FabricModJson> getModsInProject(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<SourceSet> sourceSets = new ArrayList<SourceSet>();
        sourceSets.add(SourceSetHelper.getMainSourceSet(project));
        if (extension.areEnvironmentSourceSetsSplit()) {
            sourceSets.add(SourceSetHelper.getSourceSetByName("client", project));
        }
        try {
            FabricModJson fabricModJson = FabricModJsonFactory.createFromSourceSetsNullable(project, (SourceSet[])sourceSets.toArray(SourceSet[]::new));
            if (fabricModJson != null) {
                return List.of(fabricModJson);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Collections.emptyList();
    }
}

