/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class PatternHelper {
    public static void replaceAssignmentsWithPatternVariables(@NotNull RootStatement statement, @NotNull StructClass structClass) {
        if (!structClass.hasPatternsInInstanceofSupport()) {
            return;
        }
        HashMap<VarExprent, Statement> tempVarAssignments = new HashMap<VarExprent, Statement>();
        PatternHelper.replaceAssignmentsWithPatternVariables((Statement)statement, tempVarAssignments);
        SwitchHelper.removeTempVariableDeclarations(tempVarAssignments);
    }

    private static void replaceAssignmentsWithPatternVariables(@NotNull Statement statement, @NotNull Map<VarExprent, Statement> tempVarAssignments) {
        if (statement instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)statement;
            FunctionExprent instanceOfExprent = PatternHelper.findInstanceofExprent(ifStatement);
            if (instanceOfExprent == null) {
                return;
            }
            List<Exprent> operands = instanceOfExprent.getLstOperands();
            if (operands.size() != 2 || operands.get((int)0).type != 12 || operands.get((int)1).type != 3) {
                return;
            }
            VarExprent operand = (VarExprent)operands.get(0);
            ConstExprent checkType = (ConstExprent)operands.get(1);
            PatternVariableCandidate patternVarCandidate = PatternHelper.findPatternVarCandidate(ifStatement.getIfstat(), operand, checkType);
            if (patternVarCandidate == null && ifStatement.getElsestat() != null) {
                patternVarCandidate = PatternHelper.findPatternVarCandidate(ifStatement.getElsestat(), operand, checkType);
            }
            if (patternVarCandidate == null) {
                return;
            }
            operands.remove(1);
            if (!patternVarCandidate.varExprent.isDefinition()) {
                patternVarCandidate.varExprent.setDefinition(true);
                tempVarAssignments.put(patternVarCandidate.varExprent, ifStatement);
            }
            operands.add(patternVarCandidate.varExprent);
            patternVarCandidate.ifElseStat.getExprents().remove(patternVarCandidate.assignmentExprent);
        }
        for (Statement child : statement.getStats()) {
            PatternHelper.replaceAssignmentsWithPatternVariables(child, tempVarAssignments);
        }
    }

    private static FunctionExprent findInstanceofExprent(@NotNull IfStatement ifStat) {
        return ifStat.getHeadexprent().getAllExprents(true).stream().filter(expr -> expr.type == 6).map(expr -> (FunctionExprent)expr).filter(expr -> expr.getFuncType() == 30).findFirst().orElse(null);
    }

    private static PatternVariableCandidate findPatternVarCandidate(@NotNull Statement ifElseStat, @NotNull VarExprent operand, @NotNull ConstExprent checkType) {
        if (ifElseStat instanceof BasicBlockStatement) {
            List<Exprent> castExprents;
            List<Exprent> ifElseExprents = ifElseStat.getExprents();
            if (ifElseExprents.isEmpty() || ifElseExprents.get((int)0).type != 2) {
                return null;
            }
            AssignmentExprent assignmentExprent = (AssignmentExprent)ifElseExprents.get(0);
            if (assignmentExprent.getLeft().type != 12) {
                return null;
            }
            VarExprent varExprent = (VarExprent)assignmentExprent.getLeft();
            if (assignmentExprent.getRight().type != 6) {
                return null;
            }
            FunctionExprent castExprent = (FunctionExprent)assignmentExprent.getRight();
            if (castExprent.getFuncType() != 29) {
                return null;
            }
            if (!varExprent.isDefinition()) {
                Exprent leftAssignmentPart = assignmentExprent.getLeft();
                Exprent rightAssignmentPart = assignmentExprent.getRight();
                if (leftAssignmentPart.type != 12 || rightAssignmentPart.type != 6 || ((FunctionExprent)rightAssignmentPart).getFuncType() != 29) {
                    return null;
                }
                varExprent = (VarExprent)leftAssignmentPart;
                List<Exprent> castOperands = ((FunctionExprent)rightAssignmentPart).getLstOperands();
                if (castOperands.size() != 2 || castOperands.get((int)1).type != 3) {
                    return null;
                }
                VarType castType = ((ConstExprent)castOperands.get(1)).getConstType();
                varExprent.setVarType(castType);
            }
            if ((castExprents = castExprent.getAllExprents()).size() == 2 && operand.equals(castExprents.get(0)) && checkType.equals(castExprents.get(1))) {
                return new PatternVariableCandidate(ifElseStat, assignmentExprent, varExprent);
            }
            return null;
        }
        if (ifElseStat instanceof IfStatement || ifElseStat instanceof SequenceStatement) {
            return PatternHelper.findPatternVarCandidate(ifElseStat.getFirst(), operand, checkType);
        }
        return null;
    }

    private static class PatternVariableCandidate {
        @NotNull
        private final Statement ifElseStat;
        @NotNull
        private final AssignmentExprent assignmentExprent;
        @NotNull
        private final VarExprent varExprent;

        private PatternVariableCandidate(@NotNull Statement ifElseStat, @NotNull AssignmentExprent assignmentExprent, @NotNull VarExprent varExprent) {
            this.ifElseStat = ifElseStat;
            this.assignmentExprent = assignmentExprent;
            this.varExprent = varExprent;
        }
    }
}

