/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ConsoleDecompiler
implements IBytecodeProvider,
IResultSaver {
    private final File root;
    private final Fernflower engine;
    private final Map<String, ZipOutputStream> mapArchiveStreams = new HashMap<String, ZipOutputStream>();
    private final Map<String, Set<String>> mapArchiveEntries = new HashMap<String, Set<String>>();

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java -jar fernflower.jar [-<option>=<value>]* [<source>]+ <destination>\nExample: java -jar fernflower.jar -dgs=true c:\\my\\source\\ c:\\my.jar d:\\decompiled\\");
            return;
        }
        HashMap<String, Object> mapOptions = new HashMap<String, Object>();
        ArrayList sources = new ArrayList();
        ArrayList libraries = new ArrayList();
        boolean isOption = true;
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if (isOption && arg.length() > 5 && arg.charAt(0) == '-' && arg.charAt(4) == '=') {
                String value = arg.substring(5);
                if ("true".equalsIgnoreCase(value)) {
                    value = "1";
                } else if ("false".equalsIgnoreCase(value)) {
                    value = "0";
                }
                mapOptions.put(arg.substring(1, 4), value);
                continue;
            }
            isOption = false;
            if (arg.startsWith("-e=")) {
                ConsoleDecompiler.addPath(libraries, arg.substring(3));
                continue;
            }
            ConsoleDecompiler.addPath(sources, arg);
        }
        if (sources.isEmpty()) {
            System.out.println("error: no sources given");
            return;
        }
        File destination = new File(args[args.length - 1]);
        if (!destination.isDirectory()) {
            System.out.println("error: destination '" + destination + "' is not a directory");
            return;
        }
        PrintStreamLogger logger = new PrintStreamLogger(System.out);
        ConsoleDecompiler decompiler = new ConsoleDecompiler(destination, mapOptions, logger);
        for (File library : libraries) {
            decompiler.addLibrary(library);
        }
        for (File source : sources) {
            decompiler.addSource(source);
        }
        decompiler.decompileContext();
    }

    private static void addPath(List<? super File> list, String path) {
        File file = new File(path);
        if (file.exists()) {
            list.add(file);
        } else {
            System.out.println("warn: missing '" + path + "', ignored");
        }
    }

    protected ConsoleDecompiler(File destination, Map<String, Object> options, IFernflowerLogger logger) {
        this.root = destination;
        this.engine = new Fernflower(this, this, options, logger);
    }

    public void addSource(File source) {
        this.engine.addSource(source);
    }

    public void addLibrary(File library) {
        this.engine.addLibrary(library);
    }

    public void decompileContext() {
        try {
            this.engine.decompileContext();
        }
        finally {
            this.engine.clearContext();
        }
    }

    @Override
    public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
        File file = new File(externalPath);
        if (internalPath == null) {
            return InterpreterUtil.getBytes(file);
        }
        try (ZipFile archive = new ZipFile(file);){
            ZipEntry entry = archive.getEntry(internalPath);
            if (entry == null) {
                throw new IOException("Entry not found: " + internalPath);
            }
            byte[] byArray = InterpreterUtil.getBytes(archive, entry);
            return byArray;
        }
    }

    private String getAbsolutePath(String path) {
        return new File(this.root, path).getAbsolutePath();
    }

    @Override
    public void saveFolder(String path) {
        File dir = new File(this.getAbsolutePath(path));
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new RuntimeException("Cannot create directory " + dir);
        }
    }

    @Override
    public void copyFile(String source, String path, String entryName) {
        try {
            InterpreterUtil.copyFile(new File(source), new File(this.getAbsolutePath(path), entryName));
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot copy " + source + " to " + entryName, ex);
        }
    }

    @Override
    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        File file = new File(this.getAbsolutePath(path), entryName);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            out.write(content);
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot write class file " + file, ex);
        }
    }

    @Override
    public void createArchive(String path, String archiveName, Manifest manifest) {
        File file = new File(this.getAbsolutePath(path), archiveName);
        try {
            if (!file.createNewFile() && !file.isFile()) {
                throw new IOException("Cannot create file " + file);
            }
            FileOutputStream fileStream = new FileOutputStream(file);
            ZipOutputStream zipStream = manifest != null ? new JarOutputStream((OutputStream)fileStream, manifest) : new ZipOutputStream(fileStream);
            this.mapArchiveStreams.put(file.getPath(), zipStream);
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot create archive " + file, ex);
        }
    }

    @Override
    public void saveDirEntry(String path, String archiveName, String entryName) {
        this.saveClassEntry(path, archiveName, null, entryName, null);
    }

    @Override
    public void copyEntry(String source, String path, String archiveName, String entryName) {
        block14: {
            String file = new File(this.getAbsolutePath(path), archiveName).getPath();
            if (!this.checkEntry(entryName, file)) {
                return;
            }
            try (ZipFile srcArchive = new ZipFile(new File(source));){
                ZipEntry entry = srcArchive.getEntry(entryName);
                if (entry == null) break block14;
                try (InputStream in = srcArchive.getInputStream(entry);){
                    ZipOutputStream out = this.mapArchiveStreams.get(file);
                    out.putNextEntry(new ZipEntry(entryName));
                    InterpreterUtil.copyStream(in, out);
                }
            }
            catch (IOException ex) {
                String message = "Cannot copy entry " + entryName + " from " + source + " to " + file;
                DecompilerContext.getLogger().writeMessage(message, ex);
            }
        }
    }

    @Override
    public synchronized void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        if (!this.checkEntry(entryName, file)) {
            return;
        }
        try {
            ZipOutputStream out = this.mapArchiveStreams.get(file);
            out.putNextEntry(new ZipEntry(entryName));
            if (content != null) {
                out.write(content.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException ex) {
            String message = "Cannot write entry " + entryName + " to " + file;
            DecompilerContext.getLogger().writeMessage(message, ex);
        }
    }

    private boolean checkEntry(String entryName, String file) {
        Set set = this.mapArchiveEntries.computeIfAbsent(file, k -> new HashSet());
        boolean added = set.add(entryName);
        if (!added) {
            String message = "Zip entry " + entryName + " already exists in " + file;
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
        return added;
    }

    @Override
    public void closeArchive(String path, String archiveName) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        try {
            this.mapArchiveEntries.remove(file);
            this.mapArchiveStreams.remove(file).close();
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot close " + file, IFernflowerLogger.Severity.WARN);
        }
    }
}

