/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.conditions;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.DefaultResourceConditionTypes;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7871;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceConditionsImpl
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fabric Resource Conditions");
    public static class_7699 currentFeatures = null;

    public void onInitialize() {
        ResourceConditions.register(DefaultResourceConditionTypes.TRUE);
        ResourceConditions.register(DefaultResourceConditionTypes.NOT);
        ResourceConditions.register(DefaultResourceConditionTypes.AND);
        ResourceConditions.register(DefaultResourceConditionTypes.OR);
        ResourceConditions.register(DefaultResourceConditionTypes.ALL_MODS_LOADED);
        ResourceConditions.register(DefaultResourceConditionTypes.ANY_MODS_LOADED);
        ResourceConditions.register(DefaultResourceConditionTypes.TAGS_POPULATED);
        ResourceConditions.register(DefaultResourceConditionTypes.FEATURES_ENABLED);
        ResourceConditions.register(DefaultResourceConditionTypes.REGISTRY_CONTAINS);
    }

    public static boolean applyResourceConditions(JsonObject obj, String dataType, class_2960 key, @Nullable class_6903.class_7863 registryInfo) {
        boolean debugLogEnabled = LOGGER.isDebugEnabled();
        if (obj.has("fabric:load_conditions")) {
            DataResult conditions = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("fabric:load_conditions"));
            if (conditions.isSuccess()) {
                boolean matched = ((ResourceCondition)conditions.getOrThrow()).test(registryInfo);
                if (debugLogEnabled) {
                    String verdict = matched ? "Allowed" : "Rejected";
                    LOGGER.debug("{} resource of type {} with id {}", new Object[]{verdict, dataType, key});
                }
                return matched;
            }
            LOGGER.error("Failed to parse resource conditions for file of type {} with id {}, skipping: {}", new Object[]{dataType, key, ((DataResult.Error)conditions.error().get()).message()});
        }
        return true;
    }

    public static boolean conditionsMet(List<ResourceCondition> conditions, @Nullable class_6903.class_7863 registryInfo, boolean and) {
        for (ResourceCondition condition : conditions) {
            if (condition.test(registryInfo) == and) continue;
            return !and;
        }
        return and;
    }

    public static boolean modsLoaded(List<String> modIds, boolean and) {
        for (String modId : modIds) {
            if (FabricLoader.getInstance().isModLoaded(modId) == and) continue;
            return !and;
        }
        return and;
    }

    public static boolean tagsPopulated(@Nullable class_6903.class_7863 infoGetter, class_2960 registryId, List<class_2960> tags) {
        if (infoGetter == null) {
            LOGGER.warn("Can't retrieve registry {}, failing tags_populated resource condition check", (Object)registryId);
            return false;
        }
        class_5321 registryKey = class_5321.method_29180((class_2960)registryId);
        Optional optionalInfo = infoGetter.method_46623(registryKey);
        if (optionalInfo.isPresent()) {
            class_7871 lookup = ((class_6903.class_7862)optionalInfo.get()).comp_1131();
            for (class_2960 id : tags) {
                if (!lookup.method_46733(class_6862.method_40092((class_5321)registryKey, (class_2960)id)).isEmpty()) continue;
                return false;
            }
            return true;
        }
        return tags.isEmpty();
    }

    public static boolean featuresEnabled(Collection<class_2960> features) {
        MutableBoolean foundUnknown = new MutableBoolean();
        class_7699 set = class_7701.field_40180.method_45388(features, id -> {
            LOGGER.info("Found unknown feature {}, treating it as failure", id);
            foundUnknown.setTrue();
        });
        if (foundUnknown.booleanValue()) {
            return false;
        }
        if (currentFeatures == null) {
            LOGGER.warn("Can't retrieve current features, failing features_enabled resource condition check.");
            return false;
        }
        return set.method_45400(currentFeatures);
    }

    public static boolean registryContains(@Nullable class_6903.class_7863 infoGetter, class_2960 registryId, List<class_2960> entries) {
        if (infoGetter == null) {
            LOGGER.warn("Can't retrieve registry {}, failing registry_contains resource condition check", (Object)registryId);
            return false;
        }
        class_5321 registryKey = class_5321.method_29180((class_2960)registryId);
        Optional optionalInfo = infoGetter.method_46623(registryKey);
        if (optionalInfo.isPresent()) {
            class_7871 lookup = ((class_6903.class_7862)optionalInfo.get()).comp_1131();
            for (class_2960 id : entries) {
                if (!lookup.method_46746(class_5321.method_29179((class_5321)registryKey, (class_2960)id)).isEmpty()) continue;
                return false;
            }
            return true;
        }
        return entries.isEmpty();
    }
}

