/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.conditions;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.Decoder;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_2385;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7655;
import net.minecraft.class_9248;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_7655.class})
public class RegistryLoaderMixin {
    @Unique
    private static final ThreadLocal<class_6903.class_7863> REGISTRY_INFO = new ThreadLocal();

    @Inject(method={"method_45122(Lnet/minecraft/class_3300;Lnet/minecraft/class_6903$class_7863;Lnet/minecraft/class_2385;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V"}, at={@At(value="HEAD")})
    private static <E> void captureRegistries(class_3300 resourceManager, class_6903.class_7863 infoGetter, class_2385<E> registry, Decoder<E> elementDecoder, Map<class_5321<?>, Exception> errors, CallbackInfo ci) {
        REGISTRY_INFO.set(infoGetter);
    }

    @Inject(method={"method_45122(Lnet/minecraft/class_3300;Lnet/minecraft/class_6903$class_7863;Lnet/minecraft/class_2385;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private static <E> void releaseRegistries(class_3300 resourceManager, class_6903.class_7863 infoGetter, class_2385<E> registry, Decoder<E> elementDecoder, Map<class_5321<?>, Exception> errors, CallbackInfo ci) {
        REGISTRY_INFO.remove();
    }

    @Inject(method={"Lnet/minecraft/class_7655;method_56915(Lnet/minecraft/class_2385;Lcom/mojang/serialization/Decoder;Lnet/minecraft/class_6903;Lnet/minecraft/class_5321;Lnet/minecraft/class_3298;Lnet/minecraft/class_9248;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", remap=false)}, cancellable=true)
    private static <E> void checkResourceCondition(class_2385<E> registry, Decoder<E> decoder, class_6903<JsonElement> ops, class_5321<E> key, class_3298 resource, class_9248 entryInfo, CallbackInfo ci, @Local Reader reader, @Local JsonElement jsonElement) throws IOException {
        class_6903.class_7863 registryInfoGetter = REGISTRY_INFO.get();
        if (registryInfoGetter == null) {
            return;
        }
        if (jsonElement.isJsonObject() && !ResourceConditionsImpl.applyResourceConditions(jsonElement.getAsJsonObject(), key.method_41185().toString(), key.method_29177(), registryInfoGetter)) {
            reader.close();
            ci.cancel();
        }
    }
}

