/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.indigo.renderer;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.FabricBlockModelRenderer;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessLayerRenderState;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.MaterialFinderImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableMeshImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.SimpleBlockRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainLikeRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.BlockRenderManagerAccessor;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_811;

/**
 * The Fabric default renderer implementation. Supports all
 * features defined in the API and offers no special materials.
 */
public class IndigoRenderer implements Renderer {
	public static final IndigoRenderer INSTANCE = new IndigoRenderer();

	public static final RenderMaterial STANDARD_MATERIAL = INSTANCE.materialFinder().find();

	static {
		INSTANCE.registerMaterial(RenderMaterial.STANDARD_ID, STANDARD_MATERIAL);
	}

	private final Map<class_2960, RenderMaterial> materialMap = new HashMap<>();

	private IndigoRenderer() { }

	@Override
	public MutableMesh mutableMesh() {
		return new MutableMeshImpl();
	}

	@Override
	public MaterialFinder materialFinder() {
		return new MaterialFinderImpl();
	}

	@Override
	public RenderMaterial materialById(class_2960 id) {
		return materialMap.get(id);
	}

	@Override
	public boolean registerMaterial(class_2960 id, RenderMaterial material) {
		if (materialMap.containsKey(id)) return false;

		// cast to prevent acceptance of impostor implementations
		materialMap.put(id, (RenderMaterialImpl) material);
		return true;
	}

	@Override
	public void render(class_778 modelRenderer, class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers, boolean cull, long seed, int overlay) {
		TerrainLikeRenderContext.POOL.get().bufferModel(blockView, model, state, pos, matrices, vertexConsumers, cull, seed, overlay);
	}

	@Override
	public void render(class_4587.class_4665 entry, class_4597 vertexConsumers, class_1087 model, float red, float green, float blue, int light, int overlay, class_1920 blockView, class_2338 pos, class_2680 state) {
		SimpleBlockRenderContext.POOL.get().bufferModel(entry, vertexConsumers, model, red, green, blue, light, overlay, blockView, pos, state);
	}

	@Override
	public void renderBlockAsEntity(class_776 renderManager, class_2680 state, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1920 blockView, class_2338 pos) {
		class_2464 blockRenderType = state.method_26217();

		if (blockRenderType != class_2464.field_11455) {
			class_1087 model = renderManager.method_3349(state);
			int tint = ((BlockRenderManagerAccessor) renderManager).getBlockColors().method_1697(state, null, null, 0);
			float red = (tint >> 16 & 255) / 255.0F;
			float green = (tint >> 8 & 255) / 255.0F;
			float blue = (tint & 255) / 255.0F;
			FabricBlockModelRenderer.render(matrices.method_23760(), RenderLayerHelper.entityDelegate(vertexConsumers), model, red, green, blue, light, overlay, blockView, pos, state);
			((BlockRenderManagerAccessor) renderManager).getBlockEntityModelsGetter().get().method_65535(state.method_26204(), class_811.field_4315, matrices, vertexConsumers, light, overlay);
		}
	}

	@Override
	public QuadEmitter getLayerRenderStateEmitter(class_10444.class_10446 layer) {
		return ((AccessLayerRenderState) layer).fabric_getMutableMesh().emitter();
	}
}
