/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_9891;

/**
 * Note: This interface is automatically implemented on {@link class_778} via Mixin and interface injection.
 */
public interface FabricBlockModelRenderer {
	/**
	 * Alternative for
	 * {@link class_778#method_3374(class_1920, List, class_2680, class_2338, class_4587, class_4588, boolean, int)}
	 * and
	 * {@link class_776#method_3355(class_2680, class_2338, class_1920, class_4587, class_4588, boolean, List)}
	 * that accepts a {@link class_1087} instead of a {@code List<BlockModelPart>} and a
	 * {@link class_4597} instead of a {@link class_4588}. Also accepts the random seed. <b>Prefer using
	 * this method over the vanilla alternative to correctly retrieve geometry from models that implement
	 * {@link class_1087#emitQuads(QuadEmitter, class_1920, class_2338, class_2680, class_5819, Predicate)} and to
	 * correctly buffer models that have geometry on multiple render layers.</b>
	 *
	 * <p>This method allows buffering a block model in a terrain-like context, which usually includes stages like
	 * culling, dynamic tinting, shading, and flat/smooth lighting.
	 *
	 * @param blockView The world in which to render the model. <b>Should not be empty (i.e. not
	 *                  {@link class_9891}).</b>
	 * @param model The model to render.
	 * @param state The block state.
	 * @param pos The position of the block in the world.
	 * @param matrices The matrix stack.
	 * @param vertexConsumers The vertex consumers. <b>The {@link class_1921} passed to
	 *                        {@link class_4597#getBuffer(class_1921)} is guaranteed to be one of
	 *                        {@link class_1921#method_22720()}</b>.
	 * @param cull Whether to try to cull faces hidden by other blocks.
	 * @param seed The random seed. Usually retrieved by the caller from {@link class_2680#method_26190(class_2338)}.
	 * @param overlay The overlay value to pass to output {@link class_4588}s.
	 */
	default void render(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrices, class_4597 vertexConsumers, boolean cull, long seed, int overlay) {
		Renderer.get().render((class_778) this, blockView, model, state, pos, matrices, vertexConsumers, cull, seed, overlay);
	}

	/**
	 * Alternative for
	 * {@link class_778#method_3367(class_4587.class_4665, class_4588, class_1087, float, float, float, int, int)}
	 * that accepts a {@link class_4597} instead of a {@link class_4588}. Also accepts the
	 * {@link class_1920}, {@link class_2338}, and {@link class_2680} to pass to
	 * {@link class_1087#emitQuads(QuadEmitter, class_1920, class_2338, class_2680, class_5819, Predicate)} when
	 * necessary. <b>Prefer using this method over the vanilla alternative to correctly buffer models that have geometry
	 * on multiple render layers and to provide the model with additional context.</b>
	 *
	 * <p>This method allows buffering a block model with minimal transformations to the model geometry. Usually used by
	 * entity renderers.
	 *
	 * @param matrices The matrices.
	 * @param vertexConsumers The vertex consumers. <b>The {@link class_1921} passed to
	 *                        {@link class_4597#getBuffer(class_1921)} is guaranteed to be one of
	 *                        {@link class_1921#method_22720()}</b>.
	 * @param model The model to render.
	 * @param red The red component of the tint color.
	 * @param green The green component of the tint color.
	 * @param blue The blue component of the tint color.
	 * @param light The minimum light value.
	 * @param overlay The overlay value.
	 * @param blockView The world in which to render the model. <b>Can be empty (i.e. {@link class_9891}).</b>
	 * @param pos The position of the block in the world. <b>Should be {@link class_2338#field_10980} if the world is empty.
	 *            </b>
	 * @param state The block state. <b>Should be {@code Blocks.AIR.getDefaultState()} if not applicable.</b>
	 */
	static void render(class_4587.class_4665 matrices, class_4597 vertexConsumers, class_1087 model, float red, float green, float blue, int light, int overlay, class_1920 blockView, class_2338 pos, class_2680 state) {
		Renderer.get().render(matrices, vertexConsumers, model, red, green, blue, light, overlay, blockView, pos, state);
	}
}
