/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.model;

import java.util.function.Predicate;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

/**
 * Note: This interface is automatically implemented on {@link class_10889} via Mixin and interface injection.
 */
public interface FabricBlockModelPart {
	/**
	 * Produces this model part's geometry. <b>This method must be called instead of
	 * {@link class_10889#method_68509(class_2350)} and {@link class_10889#comp_3751()}; the vanilla methods
	 * should be considered deprecated as they may not produce accurate results.</b> However, it is acceptable for a
	 * custom model part to only implement the vanilla methods as the default implementation of this method will
	 * delegate to the vanilla methods.
	 *
	 * <p>This method mainly exists for convenience when interacting with parts implemented and produced by vanilla
	 * code. Custom models should generally override
	 * {@link FabricBlockStateModel#emitQuads(QuadEmitter, class_1920, class_2338, class_2680, class_5819, Predicate)}
	 * instead of subclassing {@link class_10889} and overriding this method.
	 *
	 * @param emitter Accepts model part output.
	 * @param cullTest A test that returns {@code true} for faces which will be culled and {@code false} for faces which
	 *                 may or may not be culled. Meant to be used to cull groups of quads or expensive dynamic quads
	 *                 early for performance. Early culled quads will likely not be added the emitter, so callers of
	 *                 this method must account for this. Since model parts should be completely static, this test
	 *                 should be used whenever possible.
	 */
	default void emitQuads(QuadEmitter emitter, Predicate<@Nullable class_2350> cullTest) {
		Renderer.get().emitBlockModelPartQuads((class_10889) this, emitter, cullTest);
	}
}
