/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public final class ServerPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ServerPlayNetworking.PlayPayloadHandler<?>> {
    private final class_3244 handler;
    private final MinecraftServer server;
    private final ServerPlayNetworking.Context context;
    private boolean sentInitialRegisterPacket;
    private boolean requestedReconfigure = false;

    public ServerPlayNetworkAddon(class_3244 handler, class_2535 connection, MinecraftServer server) {
        super(ServerNetworkingImpl.PLAY, connection, "ServerPlayNetworkAddon for " + String.valueOf(handler.field_14140.method_5476()));
        this.handler = handler;
        this.server = server;
        this.context = new ContextImpl(server, handler, this);
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_20591);
    }

    @Override
    protected void invokeInitEvent() {
        ((ServerPlayConnectionEvents.Init)ServerPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.server);
    }

    public void onClientReady() {
        ((ServerPlayConnectionEvents.Join)ServerPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.server);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    @Override
    protected void receive(ServerPlayNetworking.PlayPayloadHandler<?> payloadHandler, class_8710 payload) {
        this.server.execute(() -> payloadHandler.receive(payload, this.context));
    }

    @Override
    protected void schedule(Runnable task) {
        this.handler.field_14140.method_51469().method_8503().execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_8710 packet) {
        return ServerPlayNetworking.createS2CPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((S2CPlayChannelEvents.Register)S2CPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((S2CPlayChannelEvents.Unregister)S2CPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        RegistrationPayload registrationPayload;
        if (this.sentInitialRegisterPacket && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.REGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        RegistrationPayload registrationPayload;
        if (this.sentInitialRegisterPacket && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.UNREGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerPlayConnectionEvents.Disconnect)ServerPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.server);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    public void reconfigure() {
        if (this.requestedReconfigure) {
            throw new IllegalStateException("Already requested reconfigure");
        }
        this.requestedReconfigure = true;
        this.handler.method_52414();
    }

    public boolean requestedReconfigure() {
        return this.requestedReconfigure;
    }

    private record ContextImpl(MinecraftServer server, class_3244 handler, PacketSender responseSender) implements ServerPlayNetworking.Context
    {
        private ContextImpl {
            Objects.requireNonNull(server, "server");
            Objects.requireNonNull(handler, "handler");
            Objects.requireNonNull(responseSender, "responseSender");
        }

        @Override
        public class_3222 player() {
            return this.handler.method_32311();
        }
    }
}

