/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.client.ClientCommonNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworkAddon
extends ClientCommonNetworkAddon<ClientPlayNetworking.PlayPayloadHandler<?>, class_634> {
    private final ContextImpl context;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ClientPlayNetworkAddon(class_634 handler, class_310 client) {
        super(ClientNetworkingImpl.PLAY, handler.method_48296(), "ClientPlayNetworkAddon for " + handler.method_2879().name(), handler, client);
        this.context = new ContextImpl(client, this);
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_20591);
    }

    @Override
    protected void invokeInitEvent() {
        ((ClientPlayConnectionEvents.Init)ClientPlayConnectionEvents.INIT.invoker()).onPlayInit((class_634)this.handler, this.client);
    }

    @Override
    public void onServerReady() {
        try {
            ((ClientPlayConnectionEvents.Join)ClientPlayConnectionEvents.JOIN.invoker()).onPlayReady((class_634)this.handler, this, this.client);
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception thrown while invoking ClientPlayConnectionEvents.JOIN", (Throwable)e);
        }
        this.sendInitialChannelRegistrationPacket();
        super.onServerReady();
    }

    @Override
    protected void receive(ClientPlayNetworking.PlayPayloadHandler<?> handler, class_8710 payload) {
        this.client.execute(() -> handler.receive(payload, this.context));
    }

    @Override
    public class_2596<?> createPacket(class_8710 packet) {
        return ClientPlayNetworking.createC2SPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((C2SPlayChannelEvents.Register)C2SPlayChannelEvents.REGISTER.invoker()).onChannelRegister((class_634)this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((C2SPlayChannelEvents.Unregister)C2SPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister((class_634)this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientPlayConnectionEvents.Disconnect)ClientPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect((class_634)this.handler, this.client);
    }

    @Environment(value=EnvType.CLIENT)
    private record ContextImpl(class_310 client, PacketSender responseSender) implements ClientPlayNetworking.Context
    {
        private ContextImpl {
            Objects.requireNonNull(client, "client");
            Objects.requireNonNull(responseSender, "responseSender");
        }

        @Override
        public class_746 player() {
            return Objects.requireNonNull(this.client.field_1724, "player");
        }
    }
}

