/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import io.netty.util.AsciiString;

public record RegistrationPayload(class_9154<RegistrationPayload> id, List<class_2960> channels) implements class_8710 {
	public static final class_8710.class_9154<RegistrationPayload> REGISTER = new class_8710.class_9154<>(NetworkingImpl.REGISTER_CHANNEL);
	public static final class_8710.class_9154<RegistrationPayload> UNREGISTER = new class_8710.class_9154<>(NetworkingImpl.UNREGISTER_CHANNEL);
	public static final class_9139<class_2540, RegistrationPayload> REGISTER_CODEC = codec(REGISTER);
	public static final class_9139<class_2540, RegistrationPayload> UNREGISTER_CODEC = codec(UNREGISTER);

	private RegistrationPayload(class_9154<RegistrationPayload> id, class_2540 buf) {
		this(id, read(buf));
	}

	private void write(class_2540 buf) {
		boolean first = true;

		for (class_2960 channel : channels) {
			if (first) {
				first = false;
			} else {
				buf.method_52997(0);
			}

			buf.method_52983(channel.toString().getBytes(StandardCharsets.US_ASCII));
		}
	}

	private static List<class_2960> read(class_2540 buf) {
		List<class_2960> ids = new ArrayList<>();
		StringBuilder active = new StringBuilder();

		while (buf.isReadable()) {
			byte b = buf.readByte();

			if (b != 0) {
				active.append(AsciiString.b2c(b));
			} else {
				addId(ids, active);
				active = new StringBuilder();
			}
		}

		addId(ids, active);

		return Collections.unmodifiableList(ids);
	}

	private static void addId(List<class_2960> ids, StringBuilder sb) {
		String literal = sb.toString();

		try {
			ids.add(class_2960.method_60654(literal));
		} catch (class_151 ex) {
			NetworkingImpl.LOGGER.warn("Received invalid channel identifier \"{}\"", literal);
		}
	}

	@Override
	public class_9154<? extends class_8710> method_56479() {
		return id;
	}

	private static class_9139<class_2540, RegistrationPayload> codec(class_9154<RegistrationPayload> id) {
		return class_8710.method_56484(RegistrationPayload::write, buf -> new RegistrationPayload(id, buf));
	}
}
