/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.datagen.v1.builder;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.datagen.client.SoundTypeBuilderImpl;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
@ApiStatus.NonExtendable
public interface SoundTypeBuilder {
    public static SoundTypeBuilder of(class_3414 event) {
        Objects.requireNonNull(event, "Sound event cannot be null.");
        return SoundTypeBuilder.of().subtitle(class_156.method_646((String)"subtitles", (class_2960)event.comp_3319()));
    }

    public static SoundTypeBuilder of() {
        return new SoundTypeBuilderImpl();
    }

    public SoundTypeBuilder category(class_3419 var1);

    public SoundTypeBuilder subtitle(@Nullable String var1);

    public SoundTypeBuilder sound(EntryBuilder var1);

    public SoundTypeBuilder sound(EntryBuilder var1, int var2);

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.NonExtendable
    public static interface EntryBuilder {
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final float DEFAULT_PITCH = 1.0f;
        public static final int DEFAULT_WEIGHT = 1;
        public static final int DEFAULT_ATTENUATION_DISTANCE = 16;

        public static EntryBuilder create(RegistrationType type, class_2960 id) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.create(type, id);
        }

        public static EntryBuilder ofFile(class_2960 soundFile) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.ofFile(soundFile);
        }

        public static EntryBuilder ofEvent(class_3414 event) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.ofEvent(event);
        }

        public static EntryBuilder ofEvent(class_6880<class_3414> event) {
            return SoundTypeBuilderImpl.EntryBuilderImpl.ofEvent(event);
        }

        public EntryBuilder volume(float var1);

        public EntryBuilder pitch(float var1);

        public EntryBuilder attenuationDistance(int var1);

        public EntryBuilder weight(int var1);

        public EntryBuilder stream(boolean var1);

        public EntryBuilder preload(boolean var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum RegistrationType implements class_3542
    {
        FILE("file"),
        SOUND_EVENT("event");

        public static final Codec<RegistrationType> CODEC;
        private final String name;

        private RegistrationType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(RegistrationType::values);
        }
    }
}

