/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSerializingImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-data-attachment-api-v1");

    public static void serializeAttachmentData(class_2487 nbt, class_7225.class_7874 wrapperLookup, @Nullable IdentityHashMap<AttachmentType<?>, ?> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        class_2487 compound = new class_2487();
        for (Map.Entry<AttachmentType<?>, ?> entry : attachments.entrySet()) {
            AttachmentType<?> type = entry.getKey();
            Codec<?> codec = type.persistenceCodec();
            if (codec == null) continue;
            class_6903 registryOps = wrapperLookup.method_57093((DynamicOps)class_2509.field_11560);
            codec.encodeStart((DynamicOps)registryOps, entry.getValue()).ifError(partial -> {
                LOGGER.warn("Couldn't serialize attachment {}, skipping. Error:", (Object)type.identifier());
                LOGGER.warn(partial.message());
            }).ifSuccess(serialized -> compound.method_10566(type.identifier().toString(), serialized));
        }
        nbt.method_10566("fabric:attachments", (class_2520)compound);
    }

    @Nullable
    public static IdentityHashMap<AttachmentType<?>, Object> deserializeAttachmentData(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        Optional optional = nbt.method_10562("fabric:attachments");
        if (optional.isPresent()) {
            IdentityHashMap attachments = new IdentityHashMap();
            class_2487 compound = (class_2487)optional.get();
            for (String key : compound.method_10541()) {
                AttachmentType<?> type = AttachmentRegistryImpl.get(class_2960.method_60654((String)key));
                if (type == null) {
                    LOGGER.warn("Unknown attachment type {} found when deserializing, skipping", (Object)key);
                    continue;
                }
                Codec<?> codec = type.persistenceCodec();
                if (codec == null) continue;
                class_6903 registryOps = wrapperLookup.method_57093((DynamicOps)class_2509.field_11560);
                codec.parse((DynamicOps)registryOps, (Object)compound.method_10580(key)).ifError(partial -> {
                    LOGGER.warn("Couldn't deserialize attachment {}, skipping. Error:", (Object)type.identifier());
                    LOGGER.warn(partial.message());
                }).ifSuccess(deserialized -> attachments.put(type, deserialized));
            }
            if (attachments.isEmpty()) {
                return null;
            }
            return attachments;
        }
        return null;
    }

    public static boolean hasPersistentAttachments(@Nullable IdentityHashMap<AttachmentType<?>, ?> map) {
        if (map == null) {
            return false;
        }
        for (AttachmentType<?> type : map.keySet()) {
            if (!type.isPersistent()) continue;
            return true;
        }
        return false;
    }
}

