/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.gradle;

import io.github.detekt.gradle.DetektKotlinCompilerPluginKt;
import io.github.detekt.gradle.extensions.DetektReport;
import io.github.detekt.gradle.extensions.KotlinCompileTaskDetektExtension;
import io.gitlab.arturbosch.detekt.DetektPlugin;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilerPluginSupportPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016\u00a8\u0006\u0014"}, d2={"Lio/github/detekt/gradle/DetektKotlinCompilerPlugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilerPluginSupportPlugin;", "<init>", "()V", "apply", "", "target", "Lorg/gradle/api/Project;", "applyToCompilation", "Lorg/gradle/api/provider/Provider;", "", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getCompilerPluginId", "", "getPluginArtifact", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginArtifact;", "isApplicable", "", "detekt-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDetektKotlinCompilerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetektKotlinCompilerPlugin.kt\nio/github/detekt/gradle/DetektKotlinCompilerPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1#2:181\n1#2:192\n1611#3,9:182\n1863#3:191\n1864#3:193\n1620#3:194\n*S KotlinDebug\n*F\n+ 1 DetektKotlinCompilerPlugin.kt\nio/github/detekt/gradle/DetektKotlinCompilerPlugin\n*L\n129#1:192\n129#1:182,9\n129#1:191\n129#1:193\n129#1:194\n*E\n"})
public final class DetektKotlinCompilerPlugin
implements KotlinCompilerPluginSupportPlugin {
    public void apply(@NotNull Project target) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.getPluginManager().apply(ReportingBasePlugin.class);
        DetektExtension detektExtension = (DetektExtension)((Object)target.getExtensions().findByType(DetektExtension.class));
        if (detektExtension == null) {
            detektExtension = (DetektExtension)((Object)target.getExtensions().create("detekt", DetektExtension.class, new Object[0]));
        }
        DetektExtension extension = detektExtension;
        extension.setReportsDir(((ReportingExtension)target.getExtensions().getByType(ReportingExtension.class)).file("detekt"));
        File defaultConfigFile = target.file((Object)(target.getRootProject().getLayout().getProjectDirectory().dir("config/detekt") + "/detekt.yml"));
        if (defaultConfigFile.exists()) {
            objectArray = new Object[]{defaultConfigFile};
            extension.getConfig().setFrom((Iterable)target.files(objectArray));
        }
        objectArray = target.getConfigurations().maybeCreate("detektPlugins");
        Configuration $this$apply_u24lambda_u240 = (Configuration)objectArray;
        boolean bl = false;
        $this$apply_u24lambda_u240.setVisible(false);
        $this$apply_u24lambda_u240.setTransitive(true);
        $this$apply_u24lambda_u240.setDescription("The detektPlugins libraries to be used for this project.");
        target.getTasks().withType(KotlinCompile.class).configureEach(arg_0 -> DetektKotlinCompilerPlugin.apply$lambda$9(arg_0 -> DetektKotlinCompilerPlugin.apply$lambda$8(target, extension, arg_0), arg_0));
    }

    @NotNull
    public Provider<List<SubpluginOption>> applyToCompilation(@NotNull KotlinCompilation<?> kotlinCompilation) {
        ListProperty listProperty;
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Project project = kotlinCompilation.getTarget().getProject();
        DetektExtension projectExtension = (DetektExtension)((Object)project.getExtensions().getByType(DetektExtension.class));
        KotlinCompileTaskDetektExtension taskExtension = (KotlinCompileTaskDetektExtension)kotlinCompilation.getCompileKotlinTask().getExtensions().getByType(KotlinCompileTaskDetektExtension.class);
        Configuration[] configurationArray = new Configuration[]{project.getConfigurations().getAt("detektPlugins")};
        project.getConfigurations().getByName("kotlinCompilerPluginClasspath").extendsFrom(configurationArray);
        ListProperty $this$applyToCompilation_u24lambda_u2413 = listProperty = project.getObjects().listProperty(SubpluginOption.class);
        boolean bl = false;
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("debug", ((Boolean)taskExtension.getDebug().get()).toString()));
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("configDigest", DetektKotlinCompilerPluginKt.toDigest(taskExtension.getConfig())));
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("isEnabled", ((Boolean)taskExtension.isEnabled().getOrElse((Object)false)).toString()));
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("useDefaultConfig", ((Boolean)taskExtension.getBuildUponDefaultConfig().get()).toString()));
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("allRules", ((Boolean)taskExtension.getAllRules().get()).toString()));
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("disableDefaultRuleSets", ((Boolean)taskExtension.getDisableDefaultRuleSets().get()).toString()));
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("parallel", ((Boolean)taskExtension.getParallel().get()).toString()));
        String string = project.getRootDir().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("rootDir", string));
        Object object = taskExtension.getExcludes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$applyToCompilation_u24lambda_u2413.add((Object)new SubpluginOption("excludes", DetektKotlinCompilerPluginKt.access$encodeToBase64((Set)object)));
        taskExtension.getReports().all(arg_0 -> DetektKotlinCompilerPlugin.applyToCompilation$lambda$13$lambda$12(arg_0 -> DetektKotlinCompilerPlugin.applyToCompilation$lambda$13$lambda$11(project, $this$applyToCompilation_u24lambda_u2413, projectExtension, kotlinCompilation, arg_0), arg_0));
        ListProperty options = listProperty;
        RegularFile regularFile = (RegularFile)taskExtension.getBaseline().getOrNull();
        if (regularFile != null) {
            RegularFile it = regularFile;
            boolean bl2 = false;
            options.add((Object)new SubpluginOption("baseline", it.toString()));
        }
        if (CollectionsKt.any((Iterable)((Iterable)taskExtension.getConfig()))) {
            options.add((Object)new SubpluginOption("config", CollectionsKt.joinToString$default((Iterable)((Iterable)taskExtension.getConfig()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
        }
        Intrinsics.checkNotNull((Object)options);
        return (Provider)options;
    }

    @NotNull
    public String getCompilerPluginId() {
        return "detekt-compiler-plugin";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SubpluginArtifact getPluginArtifact() {
        void $this$mapNotNullTo$iv$iv;
        Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("detekt-versions.properties");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$mapNotNull$iv = arrayList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            URLConnection uRLConnection;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            URL versions = (URL)element$iv$iv;
            boolean bl2 = false;
            Properties $this$getPluginArtifact_u24lambda_u2417_u24lambda_u2416 = new Properties();
            boolean bl3 = false;
            URLConnection $this$getPluginArtifact_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415 = uRLConnection = versions.openConnection();
            boolean bl4 = false;
            $this$getPluginArtifact_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            $this$getPluginArtifact_u24lambda_u2417_u24lambda_u2416.load(inputStream);
            if ($this$getPluginArtifact_u24lambda_u2417_u24lambda_u2416.getProperty("detektCompilerPluginVersion") == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List distinctVersions = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        String string = (String)CollectionsKt.singleOrNull((List)distinctVersions);
        if (string == null) {
            throw new IllegalStateException(("You're importing two detekt compiler plugins which have different versions. (" + CollectionsKt.joinToString$default((Iterable)distinctVersions, null, null, null, (int)0, null, null, (int)63, null) + ") Make sure to align the versions.").toString());
        }
        String version = string;
        return new SubpluginArtifact("io.github.detekt", "detekt-compiler-plugin", version);
    }

    public boolean isApplicable(@NotNull KotlinCompilation<?> kotlinCompilation) {
        Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
        Object[] objectArray = new KotlinPlatformType[]{KotlinPlatformType.jvm, KotlinPlatformType.androidJvm};
        return SetsKt.setOf((Object[])objectArray).contains(kotlinCompilation.getPlatformType());
    }

    @Nullable
    public SubpluginArtifact getPluginArtifactForNative() {
        return KotlinCompilerPluginSupportPlugin.DefaultImpls.getPluginArtifactForNative((KotlinCompilerPluginSupportPlugin)this);
    }

    private static final File apply$lambda$8$lambda$7$lambda$1(DetektExtension $extension) {
        return $extension.getBaseline();
    }

    private static final Boolean apply$lambda$8$lambda$7$lambda$2(DetektExtension $extension) {
        return $extension.getDebug();
    }

    private static final Boolean apply$lambda$8$lambda$7$lambda$3(DetektExtension $extension) {
        return $extension.getBuildUponDefaultConfig();
    }

    private static final Boolean apply$lambda$8$lambda$7$lambda$4(DetektExtension $extension) {
        return $extension.getAllRules();
    }

    private static final Boolean apply$lambda$8$lambda$7$lambda$5(DetektExtension $extension) {
        return $extension.getDisableDefaultRuleSets();
    }

    private static final Boolean apply$lambda$8$lambda$7$lambda$6(DetektExtension $extension) {
        return $extension.getParallel();
    }

    private static final Unit apply$lambda$8(Project $target, DetektExtension $extension, KotlinCompile task) {
        Object object = new Object[]{$target};
        object = task.getExtensions().create("detekt", KotlinCompileTaskDetektExtension.class, object);
        KotlinCompileTaskDetektExtension $this$apply_u24lambda_u248_u24lambda_u247 = (KotlinCompileTaskDetektExtension)object;
        boolean bl = false;
        $this$apply_u24lambda_u248_u24lambda_u247.isEnabled().convention((Provider)$extension.getEnableCompilerPlugin());
        $this$apply_u24lambda_u248_u24lambda_u247.getBaseline().convention($target.getLayout().file($target.provider(() -> DetektKotlinCompilerPlugin.apply$lambda$8$lambda$7$lambda$1($extension))));
        $this$apply_u24lambda_u248_u24lambda_u247.getDebug().convention($target.provider(() -> DetektKotlinCompilerPlugin.apply$lambda$8$lambda$7$lambda$2($extension)));
        $this$apply_u24lambda_u248_u24lambda_u247.getBuildUponDefaultConfig().convention($target.provider(() -> DetektKotlinCompilerPlugin.apply$lambda$8$lambda$7$lambda$3($extension)));
        $this$apply_u24lambda_u248_u24lambda_u247.getAllRules().convention($target.provider(() -> DetektKotlinCompilerPlugin.apply$lambda$8$lambda$7$lambda$4($extension)));
        $this$apply_u24lambda_u248_u24lambda_u247.getDisableDefaultRuleSets().convention($target.provider(() -> DetektKotlinCompilerPlugin.apply$lambda$8$lambda$7$lambda$5($extension)));
        $this$apply_u24lambda_u248_u24lambda_u247.getParallel().convention($target.provider(() -> DetektKotlinCompilerPlugin.apply$lambda$8$lambda$7$lambda$6($extension)));
        Object[] objectArray = new Object[]{$extension.getConfig()};
        $this$apply_u24lambda_u248_u24lambda_u247.getConfig().from(objectArray);
        $this$apply_u24lambda_u248_u24lambda_u247.getExcludes().convention((Iterable)DetektPlugin.Companion.getDefaultExcludes$detekt_gradle_plugin());
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final String applyToCompilation$lambda$13$lambda$11$lambda$10(DetektExtension $projectExtension, KotlinCompilation $kotlinCompilation, DetektReport $report) {
        return new File($projectExtension.getReportsDir(), $kotlinCompilation.getName() + '.' + $report.getName()).getAbsolutePath();
    }

    private static final Unit applyToCompilation$lambda$13$lambda$11(Project $project, ListProperty $this_apply, DetektExtension $projectExtension, KotlinCompilation $kotlinCompilation, DetektReport report) {
        report.getEnabled().convention((Object)true);
        report.getDestination().convention($project.getLayout().getProjectDirectory().file($project.getProviders().provider(() -> DetektKotlinCompilerPlugin.applyToCompilation$lambda$13$lambda$11$lambda$10($projectExtension, $kotlinCompilation, report))));
        if (((Boolean)report.getEnabled().get()).booleanValue()) {
            $this_apply.add((Object)new SubpluginOption("report", report.getName() + ':' + ((File)report.getDestination().getAsFile().get()).getAbsolutePath()));
        }
        return Unit.INSTANCE;
    }

    private static final void applyToCompilation$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

