/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok.tasks.internal;

import io.freefair.gradle.plugins.lombok.tasks.internal.LombokConfigParameters;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import lombok.launch.LombokApi;
import org.gradle.api.file.RegularFile;
import org.gradle.workers.WorkAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LombokConfigAction
implements WorkAction<LombokConfigParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LombokConfigAction.class);

    public void execute() {
        LombokApi lombokApi = new LombokApi();
        File outputFile = ((RegularFile)((LombokConfigParameters)this.getParameters()).getOutputFile().get()).getAsFile();
        long start = System.nanoTime();
        List arguments = (List)((LombokConfigParameters)this.getParameters()).getArgs().get();
        try (OutputStream out = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            lombokApi.config(out, arguments);
        }
        Duration duration = Duration.ofNanos(System.nanoTime() - start);
        if (duration.getSeconds() > 1L) {
            log.warn("lombok config {} took {}ms", (Object)arguments, (Object)duration.toMillis());
        } else {
            log.info("lombok config {} took {}ms", (Object)arguments, (Object)duration.toMillis());
        }
    }
}

