/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.cli;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.patch.Patcher;
import io.codechicken.diffpatch.util.ConsumingOutputStream;
import io.codechicken.diffpatch.util.Diff;
import io.codechicken.diffpatch.util.FileCollector;
import io.codechicken.diffpatch.util.IOValidationException;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.Patch;
import io.codechicken.diffpatch.util.PatchFile;
import io.codechicken.diffpatch.util.PatchMode;
import io.codechicken.diffpatch.util.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.NullOutputStream;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PatchOperation
extends CliOperation<PatchesSummary> {
    final boolean summary;
    final Input baseInput;
    final Input patchesInput;
    final String aPrefix;
    final String bPrefix;
    final Output patchedOutput;
    @Nullable
    final Output rejectsOutput;
    final float minFuzz;
    final int maxOffset;
    final PatchMode mode;
    final String patchesPrefix;
    final String lineEnding;
    final String[] ignorePrefixes;

    private PatchOperation(PrintStream logger, LogLevel level, Consumer<PrintStream> helpCallback, boolean summary, Input baseInput, Input patchesInput, String aPrefix, String bPrefix, Output patchedOutput, @Nullable Output rejectsOutput, float minFuzz, int maxOffset, PatchMode mode, String patchesPrefix, String lineEnding, String[] ignorePrefixes) {
        super(logger, level, helpCallback);
        this.summary = summary;
        this.baseInput = baseInput;
        this.patchesInput = patchesInput;
        this.aPrefix = aPrefix;
        this.bPrefix = bPrefix;
        this.patchedOutput = patchedOutput;
        this.rejectsOutput = rejectsOutput;
        this.minFuzz = minFuzz;
        this.maxOffset = maxOffset;
        this.mode = mode;
        this.patchesPrefix = patchesPrefix;
        this.lineEnding = lineEnding;
        this.ignorePrefixes = ignorePrefixes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CliOperation.Result<PatchesSummary> operate() throws IOException {
        boolean patchSuccess;
        try {
            this.baseInput.validate("base input");
            this.baseInput.validate("patches input");
            this.patchedOutput.validate("patched output");
            if (this.rejectsOutput != null) {
                this.rejectsOutput.validate("rejects output");
            }
        }
        catch (IOValidationException ex) {
            this.log(LogLevel.ERROR, ex.getMessage(), new Object[0]);
            this.printHelp();
            return new CliOperation.Result<PatchesSummary>(-1);
        }
        FileCollector outputCollector = new FileCollector();
        FileCollector rejectCollector = new FileCollector();
        PatchesSummary summary = new PatchesSummary();
        if (this.baseInput instanceof Input.SingleInput && this.patchesInput instanceof Input.SingleInput) {
            Input.SingleInput base = (Input.SingleInput)this.baseInput;
            Input.SingleInput patches = (Input.SingleInput)this.patchesInput;
            if (!(this.patchedOutput instanceof Output.SingleOutput)) {
                this.log(LogLevel.ERROR, "Can't specify patched output directory or archive when patching single file.", new Object[0]);
                this.printHelp();
                return new CliOperation.Result<PatchesSummary>(-1);
            }
            Output.SingleOutput output = (Output.SingleOutput)this.patchedOutput;
            if (this.rejectsOutput != null && !(this.rejectsOutput instanceof Output.SingleOutput)) {
                this.log(LogLevel.ERROR, "Can't specify reject output directory or archive when patching single file.", new Object[0]);
                this.printHelp();
                return new CliOperation.Result<PatchesSummary>(-1);
            }
            Output.SingleOutput rejects = (Output.SingleOutput)this.rejectsOutput;
            PatchFile patchFile = PatchFile.fromLines(patches.name(), patches.readLines(), true);
            boolean success = this.doPatch(outputCollector, rejectCollector, summary, base.name(), base.readLines(), patchFile, this.minFuzz, this.maxOffset, this.mode);
            FileCollector.CollectedEntry outputEntry = outputCollector.getSingleFile();
            FileCollector.CollectedEntry rejectEntry = rejectCollector.getSingleFile();
            try (OutputStream os = output.open();){
                os.write(outputEntry.toBytes(this.lineEnding, false));
                os.flush();
            }
            if (rejectEntry != null && rejects != null) {
                os = rejects.open();
                var14_28 = null;
                try {
                    os.write(rejectEntry.toBytes(this.lineEnding, false));
                }
                catch (Throwable throwable) {
                    var14_28 = throwable;
                    throw throwable;
                }
                finally {
                    if (os != null) {
                        if (var14_28 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable) {
                                var14_28.addSuppressed(throwable);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            if (this.summary) {
                summary.print(this.logger, true);
            }
            return new CliOperation.Result<PatchesSummary>(success ? 0 : 1, summary);
        }
        if (!(this.baseInput instanceof Input.MultiInput)) {
            this.log(LogLevel.ERROR, "Can't patch between single files and folders/archives.", new Object[0]);
            this.printHelp();
            return new CliOperation.Result<PatchesSummary>(-1);
        }
        if (!(this.patchesInput instanceof Input.MultiInput)) {
            this.log(LogLevel.ERROR, "Can't patch between folders/archives and single files.", new Object[0]);
            this.printHelp();
            return new CliOperation.Result<PatchesSummary>(-1);
        }
        try (Input.MultiInput base = (Input.MultiInput)this.baseInput;
             Input.MultiInput patches = (Input.MultiInput)this.patchesInput;){
            base.open("");
            patches.open(this.patchesPrefix);
            Set<String> baseIndex = Utils.filterPrefixed(base.index(), this.ignorePrefixes);
            Set<String> patchesIndex = patches.index();
            patchSuccess = this.doPatch(outputCollector, rejectCollector, summary, baseIndex, patchesIndex, base, patches, this.minFuzz, this.maxOffset, this.mode);
        }
        var6_8 = null;
        try (Output.MultiOutput output = (Output.MultiOutput)this.patchedOutput;){
            output.open(!this.patchedOutput.isSamePath(this.baseInput));
            for (Map.Entry<String, FileCollector.CollectedEntry> entry : outputCollector.get().entrySet()) {
                output.write(entry.getKey(), entry.getValue().toBytes(this.lineEnding, false));
            }
        }
        catch (Throwable throwable) {
            var6_8 = throwable;
            throw throwable;
        }
        if (this.rejectsOutput != null) {
            output = (Output.MultiOutput)this.rejectsOutput;
            var6_8 = null;
            try {
                output.open(true);
                for (Map.Entry<String, FileCollector.CollectedEntry> entry : rejectCollector.get().entrySet()) {
                    output.write(entry.getKey(), entry.getValue().toBytes(this.lineEnding, true));
                }
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (output != null) {
                    if (var6_8 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        output.close();
                    }
                }
            }
        }
        if (this.summary) {
            summary.print(this.logger, false);
        }
        return new CliOperation.Result<PatchesSummary>(patchSuccess ? 0 : 1, summary);
    }

    private boolean doPatch(FileCollector oCollector, FileCollector rCollector, PatchesSummary summary, Set<String> bEntries, Set<String> pEntries, Input.MultiInput baseInput, Input.MultiInput patchesInput, float minFuzz, int maxOffset, PatchMode mode) throws IOException {
        PatchFile patchFile;
        HashMap patchFiles = FastStream.of(pEntries).map(e -> {
            try {
                return PatchFile.fromLines(e, patchesInput.readLines((String)e), true);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read patch file.", ex);
            }
        }).toMap(e -> {
            if (e.patchedPath == null || "/dev/null".equals(e.patchedPath)) {
                return e.name.substring(0, e.name.lastIndexOf(".patch"));
            }
            if (e.patchedPath.startsWith("b/")) {
                return e.patchedPath.substring(2);
            }
            if (e.patchedPath.startsWith(this.bPrefix)) {
                return StringUtils.removeStart((String)e.patchedPath.substring(this.bPrefix.length()), (String)"/");
            }
            return e.patchedPath;
        }, Function.identity());
        LinkedHashSet addedFiles = FastStream.of(patchFiles.keySet()).filter(e -> "/dev/null".equals(((PatchFile)patchFiles.get((Object)e)).basePath)).sorted().toLinkedHashSet();
        LinkedHashSet removedFiles = FastStream.of(patchFiles.keySet()).filter(e -> "/dev/null".equals(((PatchFile)patchFiles.get((Object)e)).patchedPath)).sorted().toLinkedHashSet();
        ArrayList notPatched = FastStream.of(bEntries).filter(e -> !patchFiles.containsKey(e)).sorted().toList();
        ArrayList patchedFiles = FastStream.of(bEntries).filterNot(removedFiles::contains).filter(patchFiles::containsKey).sorted().toList();
        ArrayList missingFiles = FastStream.of(patchFiles.keySet()).filterNot(addedFiles::contains).filter(e -> !bEntries.contains(e)).sorted().toList();
        boolean result = true;
        for (String file : notPatched) {
            ++summary.unchangedFiles;
            oCollector.consume(file, baseInput.read(file));
        }
        for (String file : addedFiles) {
            ++summary.addedFiles;
            patchFile = (PatchFile)patchFiles.get(file);
            this.log(LogLevel.DEBUG, "Added: " + file, new Object[0]);
            oCollector.consume(file, FastStream.of(patchFile.patches).flatMap(Patch::getPatchedLines).toList());
        }
        for (String file : removedFiles) {
            ++summary.removedFiles;
            this.log(LogLevel.DEBUG, "Removed: " + file, new Object[0]);
        }
        for (String file : patchedFiles) {
            ++summary.changedFiles;
            patchFile = (PatchFile)patchFiles.get(file);
            List<String> baseLines = baseInput.readLines(file);
            result &= this.doPatch(oCollector, rCollector, summary, file, baseLines, patchFile, minFuzz, maxOffset, mode);
        }
        for (String file : missingFiles) {
            ++summary.missingFiles;
            patchFile = (PatchFile)patchFiles.get(file);
            ArrayList<String> lines = new ArrayList<String>(patchFile.toLines(false));
            lines.add(0, "++++ Target missing");
            this.log(LogLevel.WARN, "Missing patch target for %s", patchFile.name);
            rCollector.consume(patchFile.name, lines);
            result = false;
        }
        return result;
    }

    private boolean doPatch(FileCollector outputCollector, FileCollector rejectCollector, PatchesSummary summary, String baseName, List<String> base, PatchFile patchFile, float minFuzz, int maxOffset, PatchMode mode) {
        Patcher patcher = new Patcher(patchFile, base, minFuzz, maxOffset);
        this.log(LogLevel.DEBUG, "Patching: " + baseName, new Object[0]);
        List<Patcher.Result> results = patcher.patch(mode);
        ArrayList<String> rejectLines = new ArrayList<String>();
        boolean first = true;
        for (int i = 0; i < results.size(); ++i) {
            Patcher.Result result = results.get(i);
            if (result.mode != null) {
                switch (result.mode) {
                    case EXACT: {
                        ++summary.exactMatches;
                        summary.overallQuality += 100.0;
                        break;
                    }
                    case ACCESS: {
                        ++summary.accessMatches;
                        summary.overallQuality += 100.0;
                        break;
                    }
                    case OFFSET: {
                        ++summary.offsetMatches;
                        summary.overallQuality += 100.0;
                        break;
                    }
                    case FUZZY: {
                        ++summary.fuzzyMatches;
                        summary.overallQuality += (double)(result.fuzzyQuality * 100.0f);
                    }
                }
            } else {
                ++summary.failedMatches;
            }
            if (!result.success) {
                if (!first) {
                    rejectLines.add("");
                } else if (!this.level.shouldLog(LogLevel.DEBUG)) {
                    this.log(LogLevel.WARN, "Patching: " + baseName, new Object[0]);
                }
                this.log(LogLevel.WARN, " Hunk %d: %s", i, result.summary());
                first = false;
                rejectLines.add("++++ REJECTED HUNK: " + (i + 1));
                rejectLines.add(result.patch.getHeader());
                FastStream.of(result.patch.diffs).map(Diff::toString).forEach(rejectLines::add);
                rejectLines.add("++++ END HUNK");
                continue;
            }
            this.log(LogLevel.DEBUG, " Hunk %d: %s", i, result.summary());
        }
        List<String> lines = patcher.lines;
        if (!lines.isEmpty()) {
            if (lines.get(lines.size() - 1).isEmpty()) {
                if (!patchFile.noNewLine) {
                    lines.remove(lines.size() - 1);
                }
            } else {
                lines.add("");
            }
        }
        outputCollector.consume(baseName, lines);
        if (!rejectLines.isEmpty()) {
            rejectCollector.consume(patchFile.name + ".rej", rejectLines);
            return false;
        }
        return true;
    }

    public static void bakePatches(Input.MultiInput input, Output.MultiOutput output, String lineEnding) throws IOException {
        PatchOperation.bakePatches(input, "", output, lineEnding);
    }

    public static void bakePatches(Input.MultiInput input, String prefix, Output.MultiOutput output, String lineEnding) throws IOException {
        try {
            input.validate("bake input");
        }
        catch (IOValidationException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        try (Input.MultiInput in = input;
             Output.MultiOutput out = output;){
            in.open(prefix);
            out.open(true);
            for (String file : in.index()) {
                PatchFile patchFile = PatchFile.fromLines(file, in.readLines(file), true);
                out.write(file, PatchOperation.bakePatch(patchFile, lineEnding).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static String bakePatch(PatchFile patchFile, String lineEnding) {
        List<String> lines = patchFile.toLines(false);
        return String.join((CharSequence)lineEnding, lines) + lineEnding;
    }

    public static class Builder {
        private static final PrintStream NULL_STREAM = new PrintStream((OutputStream)NullOutputStream.INSTANCE);
        private PrintStream logger = NULL_STREAM;
        private Consumer<PrintStream> helpCallback = SneakyUtils.nullCons();
        private LogLevel level = LogLevel.WARN;
        private boolean summary;
        @Nullable
        private Input baseInput;
        @Nullable
        private Input patchesInput;
        @Nullable
        private Output patchedOutput;
        @Nullable
        private Output rejectsOutput;
        private float minFuzz = 0.5f;
        private int maxOffset = 5;
        private PatchMode mode = PatchMode.EXACT;
        private String patchesPrefix = "";
        private String aPrefix = "a/";
        private String bPrefix = "b/";
        private String lineEnding = System.lineSeparator();
        private final List<String> ignorePrefixes = new LinkedList<String>();

        private Builder() {
        }

        public Builder logTo(Consumer<String> func) {
            return this.logTo(new ConsumingOutputStream(func));
        }

        public Builder logTo(PrintStream logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Builder logTo(OutputStream logger) {
            return this.logTo(new PrintStream(logger));
        }

        public Builder helpCallback(Consumer<PrintStream> helpCallback) {
            this.helpCallback = Objects.requireNonNull(helpCallback);
            return this;
        }

        public Builder level(LogLevel level) {
            this.level = level;
            return this;
        }

        public Builder summary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder baseInput(Input baseInput) {
            this.baseInput = Objects.requireNonNull(baseInput);
            return this;
        }

        public Builder patchesInput(Input patchesInput) {
            this.patchesInput = Objects.requireNonNull(patchesInput);
            return this;
        }

        public Builder aPrefix(String aPrefix) {
            this.aPrefix = aPrefix;
            return this;
        }

        public Builder bPrefix(String bPrefix) {
            this.bPrefix = bPrefix;
            return this;
        }

        public Builder patchedOutput(Output patchedOutput) {
            this.patchedOutput = Objects.requireNonNull(patchedOutput);
            return this;
        }

        public Builder rejectsOutput(@Nullable Output rejectsOutput) {
            this.rejectsOutput = rejectsOutput;
            return this;
        }

        public Builder minFuzz(float minFuzz) {
            this.minFuzz = minFuzz;
            return this;
        }

        public Builder maxOffset(int maxOffset) {
            this.maxOffset = maxOffset;
            return this;
        }

        public Builder mode(PatchMode mode) {
            this.mode = Objects.requireNonNull(mode);
            return this;
        }

        public Builder patchesPrefix(String patchesPrefix) {
            this.patchesPrefix = Objects.requireNonNull(patchesPrefix);
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public Builder ignorePrefix(String prefix) {
            this.ignorePrefixes.add(prefix);
            return this;
        }

        public PatchOperation build() {
            if (this.baseInput == null) {
                throw new IllegalStateException("baseInput is required.");
            }
            if (this.patchesInput == null) {
                throw new IllegalStateException("patchesInput is required.");
            }
            if (this.patchedOutput == null) {
                throw new IllegalStateException("patchedOutput is required.");
            }
            return new PatchOperation(this.logger, this.level, this.helpCallback, this.summary, this.baseInput, this.patchesInput, this.aPrefix, this.bPrefix, this.patchedOutput, this.rejectsOutput, this.minFuzz, this.maxOffset, this.mode, this.patchesPrefix, this.lineEnding, this.ignorePrefixes.toArray(new String[0]));
        }
    }

    public static class PatchesSummary {
        public int unchangedFiles;
        public int addedFiles;
        public int changedFiles;
        public int removedFiles;
        public int missingFiles;
        public int failedMatches;
        public int exactMatches;
        public int accessMatches;
        public int offsetMatches;
        public int fuzzyMatches;
        public double overallQuality;

        public void print(PrintStream logger, boolean slim) {
            logger.println("Patch Summary:");
            if (!slim) {
                logger.println(" Un-changed files: " + this.unchangedFiles);
                logger.println(" Added files:      " + this.addedFiles);
                logger.println(" Changed files:    " + this.changedFiles);
                logger.println(" Removed files:    " + this.removedFiles);
                logger.println(" Missing files:    " + this.missingFiles);
            }
            logger.println();
            logger.println(" Failed matches:   " + this.failedMatches);
            logger.println(" Exact matches:    " + this.exactMatches);
            logger.println(" Access matches:   " + this.accessMatches);
            logger.println(" Offset matches:   " + this.offsetMatches);
            logger.println(" Fuzzy matches:    " + this.fuzzyMatches);
            logger.printf("Overall Quality   %.2f%%%n", this.overallQuality / (double)(this.failedMatches + this.exactMatches + this.accessMatches + this.offsetMatches + this.fuzzyMatches));
        }
    }
}

